package com.gingersoft.gsa.cloud.table.mvp.ui.adapter;

import android.content.Context;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import android.text.TextUtils;
import android.view.Gravity;
import android.view.View;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.gingersoft.gsa.cloud.aspectj.SingleClick;
import com.gingersoft.gsa.cloud.aspectj.XClickUtil;
import com.gingersoft.gsa.cloud.base.utils.time.TimeUtil;
import com.gingersoft.gsa.cloud.base.utils.time.TimeUtils;
import com.gingersoft.gsa.cloud.table.R;
import com.gingersoft.gsa.cloud.table.R2;
import com.gingersoft.gsa.cloud.base.common.bean.TableBean;
import com.jess.arms.base.BaseHolder;
import com.jess.arms.base.DefaultAdapter;
import com.jess.arms.utils.ArmsUtils;
import com.qmuiteam.qmui.alpha.QMUIAlphaRelativeLayout;
import com.qmuiteam.qmui.alpha.QMUIAlphaTextView;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

import butterknife.BindView;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2018/8/31
 * 修订历史：2018/8/31
 * 描述：
 */

public class TableAdapter extends DefaultAdapter<TableBean.DataBean> {

    private Context mContext;

    //当前功能（1：所有餐台、2：餐台带状态）
    private int mFunction;

    //Item行数（行数根据数据自动计算）
    private int ItemRowCount = 6;
    //Item高度
    private int ItemColHeight;

    //展示的布局高度
    private float mDiaplayScreenHeight;

    private int mTableTextSize;

    private int style;

    public TableAdapter(Context context, List<TableBean.DataBean> infos, float diaplayScreenHeight, int function) {
        super(infos);
        this.mContext = context;
        this.mFunction = function;
        this.mDiaplayScreenHeight = diaplayScreenHeight;
        this.mTableTextSize = 20;

        initItemDispalyHeight();
    }

    public void initItemDispalyHeight() {
        float screenHeight = mDiaplayScreenHeight - 75 - 75;
        ItemColHeight = (int) Math.ceil((double) screenHeight / (double) (ItemRowCount));
        ItemColHeight = ItemColHeight - 3;
    }

    @Override
    public int getItemCount() {
        return mInfos.size();
    }

    @Override
    public BaseHolder<TableBean.DataBean> getHolder(View v, int viewType) {
        return new TableItemHolder(v);
    }

    @Override
    public int getLayoutId(int viewType) {
        return R.layout.table_recycler_table;
    }

    private Date date;

    class TableItemHolder extends BaseHolder<TableBean.DataBean> {

        @BindView(R2.id.ll_container)
        LinearLayout ll_container;
        @BindView(R2.id.rl_table)
        QMUIAlphaRelativeLayout rl_table;
        @BindView(R2.id.btn_table)
        TextView btn_table;
        @BindView(R2.id.tv_people)
        TextView tv_people;
        @BindView(R2.id.tv_open_duration)
        TextView tv_open_duration;
        //        @BindView(R2.id.btn_showMain)
//        Button btn_showMain;
//        @BindView(R2.id.iv_vip)
//        ImageView iv_vip;
//        @BindView(R2.id.tv_scan_flag)
//        TextView tv_scan_flag;

        public TableItemHolder(View itemView) {
            super(itemView);
        }

        @Override
        public void setData(TableBean.DataBean item, int position) {

            initItemData(item);
            initItemDispalyMetrics();
            initItemTableClick(item, position);
            initTableBackground(item);
        }

        private void initItemData(TableBean.DataBean item) {

            btn_table.setText(item.getTableName());

            if (item.getStatus() != 0) {
                tv_people.setVisibility(View.VISIBLE);
                tv_people.setText(item.getPerson() + "人");
                String createDate = item.getCreateTime();
                String createTime = TimeUtil.getStringByFormat(new Date(createDate), TimeUtil.dateFormatYMDHMS);
                String currentTime = TimeUtil.getStringByFormat(System.currentTimeMillis(), TimeUtil.dateFormatYMDHMS);
                long[] difference = TimeUtil.getDistanceTimes2(createTime, currentTime);
                if (difference[0] != 0) {
                    tv_open_duration.setText(difference[0] + ":" + difference[1] + ":" + difference[2]);
                } else {
                    tv_open_duration.setText(difference[1] + ":" + difference[2]);
                }
                tv_open_duration.setVisibility(View.VISIBLE);
            } else {
                tv_people.setVisibility(View.GONE);
                tv_open_duration.setVisibility(View.GONE);
            }
        }

        private void initTableBackground(TableBean.DataBean item) {

//            if (item.getClearstate() > 0) {
//                setBackGroundWork(item, "Cleaning", R.drawable.tablebutton_splite, R.drawable.tablebutton_splite_new, R.color.black);
//                return;
//            }

//            if (item.getSplitStatus() != 0) {
//                setBackGroundWork(item, "888", R.drawable.tablebutton_splite, R.drawable.tablebutton_splite_new, R.color.black);
//            } else {
            if (item.getUseStatus() == 1) {
                setBackGroundWork(item, "999", R.drawable.table_shape_table_use, R.drawable.tablebutton_red_new, R.color.theme_white_color);
            } else {
                switch (item.getStatus()) {
                    case 0:
                        setBackGroundWork(item, "0", R.drawable.table_shape_table_nomal, R.drawable.tablebutton_skyblue_new, R.color.black);
                        break;
                    case 1:
                        setBackGroundWork(item, "1", R.drawable.tablebutton_default, R.drawable.tablebutton_default_new, R.color.theme_white_color);
                        break;
                    case 2:
                        setBackGroundWork(item, "2", R.drawable.table_shape_table_send, R.drawable.tablebutton_glassgreen_new, R.color.theme_white_color);
                        break;
                    case 3:
                        setBackGroundWork(item, "3", R.drawable.table_shape_table_print, R.drawable.tablebutton_yellow_new, R.color.theme_white_color);
                        break;
                    case 4:
                        setBackGroundWork(item, "4", R.drawable.tablebutton_violet, R.drawable.tablebutton_violet_new, R.color.theme_white_color);
                        break;
                    case 5:
                        setBackGroundWork(item, "5", R.drawable.tablebutton_default, R.drawable.tablebutton_default_new, R.color.theme_white_color);
                        break;
                    case 6:
                        setBackGroundWork(item, "6", R.drawable.tablebutton_default, R.drawable.tablebutton_default_new, R.color.theme_white_color);
                        break;
                }
            }
        }

        private void initItemTableClick(TableBean.DataBean item, int position) {
            rl_table.setOnClickListener(new View.OnClickListener() {

                @Override
                public void onClick(View v) {
                    if (XClickUtil.isFastDoubleClick(v, 1000)) {
                        return;
                    }
                    if (mOnItemClickListener != null) {
                        mOnItemClickListener.onItemClick(item, position);
                    }
                }
            });
        }

        private void initItemDispalyMetrics() {
            if (btn_table.getGravity() != Gravity.CENTER) {
                rl_table.setGravity(Gravity.CENTER);
                LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams) rl_table.getLayoutParams();
                lp.height = ItemColHeight;
                rl_table.setLayoutParams(lp);
            }
            LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams) rl_table.getLayoutParams();
            rl_table.setLayoutParams(lp);

            rl_table.setMinimumHeight(ItemColHeight);

            LinearLayout.LayoutParams relativeLayout = new LinearLayout.LayoutParams(LinearLayout.LayoutParams.MATCH_PARENT, LinearLayout.LayoutParams.MATCH_PARENT);
            relativeLayout.height = ItemColHeight;
            rl_table.setLayoutParams(relativeLayout);
        }

        private void setBackGroundWork(TableBean.DataBean item, String workstatu, int defaultMainback, int defaultChildBack, int defaultFontColor) {
            String tableName = item.getTableName();
            if (defaultMainback != -1) {
                ll_container.setBackground(mContext.getResources().getDrawable(defaultMainback));
            }
//            if (defaultChildBack != -1) {
//                btn_table.setBackground(mContext.getResources().getDrawable(defaultMainback));
//                btn_showMain.setBackground(mContext.getResources().getDrawable(defaultMainback));
//            }
            btn_table.setTextColor(mContext.getResources().getColor(defaultFontColor));
//            btn_showMain.setTextColor(mContext.getResources().getColor(defaultFontColor));

            /**
             * 可使用   0
             * 操作中   1
             * 已开台   2
             * 已印单   3
             * 已结账   4
             * 连台     6
             */
//            StateListDrawable bgShape = (StateListDrawable) btn_table.getBackground();
//            GradientDrawable d = (GradientDrawable) bgShape.getCurrent();
//            switch (workstatu) {
//                case "0":
//                    d.setColor(ArmsUtils.getColor(mContext, R.color.table_normal));
//                    break;
//                case "1":
//                case "2":
//                    d.setColor(ArmsUtils.getColor(mContext, R.color.table_send));
//                    break;
//                case "3":
//                    d.setColor(ArmsUtils.getColor(mContext, R.color.table_print));
//                    break;
//                case "4":
//                    d.setColor(ArmsUtils.getColor(mContext, R.color.table_normal));
//                    break;
//                case "5":
//                    d.setColor(ArmsUtils.getColor(mContext, R.color.table_normal));
//                    break;
//                case "6":
//                    d.setColor(ArmsUtils.getColor(mContext, R.color.Violet));
//                    break;
//                case "999":
//                    d.setColor(ArmsUtils.getColor(mContext, R.color.table_use));
//                    break;
//
//            }
//            com.elegant.bin.gsa.mvp.main.model.bean.Color.DatasBean cs;
//
//            for (TableWorkStatusColor tws : GSAApplication.androidSetting.getTableWorkStatusColors()) {
//                if (tws.getWorkstatu().equalsIgnoreCase(workstatu)) {
//                    cs = AndroidSettingUtils.getColorById(tws.getColorid());
//                    if (cs != null) {
//                        StateListDrawable bgShape = (StateListDrawable) btn_table.getBackground();
//                        int[] states = bgShape.getState();
//                        for (int i = 0; i < states.length; i++) {
//                            if (states[i] == android.R.attr.state_focused || states[i] == android.R.attr.state_enabled) {
//                                GradientDrawable d = (GradientDrawable) bgShape.getCurrent();
//                                if (!TextUtils.isEmpty(cs.getAndroidColor())) {
//                                    d.setColor(Color.parseColor(cs.getAndroidColor()));
//                                } else {
//                                    d.setColor(ArmsUtils.getColor(mContext, R.color.Grass_green));
//                                }
//                            }
//                        }
//                        bgShape = (StateListDrawable) btn_showMain.getBackground();
//                        states = bgShape.getState();
//                        for (int i = 0; i < states.length; i++) {
//                            if (states[i] == android.R.attr.state_focused || states[i] == android.R.attr.state_enabled) {
//                                GradientDrawable d = (GradientDrawable) bgShape.getCurrent();
//                                if (!TextUtils.isEmpty(cs.getAndroidColor())) {
//                                    d.setColor(Color.parseColor(cs.getAndroidColor()));
//                                } else {
////                                    d.setColor(Color.parseColor(""));
//                                }
//                            }
//                        }
//                        if (!TextUtils.isEmpty(cs.getAndroidfontcolor())) {
//                            btn_table.setTextColor(Color.parseColor(cs.getAndroidfontcolor()));
//                            btn_showMain.setTextColor(Color.parseColor(cs.getAndroidfontcolor()));
//                        }
//                    }
//                    break;
//                }
//            }
//            if (item.getSplitStatus() == 1 || item.isUsing()) {
//                return;
//            }
//            switch (item.getStatus()) {
//                case 2://开台状态下要增加随时时间增加，改变色的功能
//                    for (TableStatusOpenedOverTime tws : GSAApplication.androidSetting.getTableStatusOpenedOverTimeColors()) {
//                        if (item.getOropentime_diff() >= tws.times) {
//                            cs = AndroidSettingUtils.getColorById(tws.getColorid());
//                            if (cs != null) {
//                                StateListDrawable bgShape = (StateListDrawable) btn_table.getBackground();
//                                int[] states = bgShape.getState();
//                                for (int i = 0; i < states.length; i++) {
//                                    if (states[i] == android.R.attr.state_focused || states[i] == android.R.attr.state_enabled) {
//                                        GradientDrawable d = (GradientDrawable) bgShape.getCurrent();
//                                        d.setColor(Color.parseColor(cs.getAndroidColor()));
//                                    }
//                                }
//                                bgShape = (StateListDrawable) btn_showMain.getBackground();
//                                states = bgShape.getState();
//                                for (int i = 0; i < states.length; i++) {
//                                    if (states[i] == android.R.attr.state_focused || states[i] == android.R.attr.state_enabled) {
//                                        GradientDrawable d = (GradientDrawable) bgShape.getCurrent();
//                                        d.setColor(Color.parseColor(cs.getAndroidColor()));
//                                    }
//                                }
//                                btn_table.setTextColor(Color.parseColor(cs.getAndroidfontcolor()));
//                                btn_showMain.setTextColor(Color.parseColor(cs.getAndroidfontcolor()));
//                            }
//                            //break;
//                        }
//                    }
//                    break;
//                case 3://印单状态下要增加随时间增加，改变色的功能
//                    for (TableStatusPrintedOverTime tws : GSAApplication.androidSetting.getTableStatusPrintedOverTimeColors()) {
//                        if (item.getOropentime_diff() >= tws.times) {
//                            cs = AndroidSettingUtils.getColorById(tws.getColorid());
//                            if (cs != null) {
//                                StateListDrawable bgShape = (StateListDrawable) btn_table.getBackground();
//                                int[] states = bgShape.getState();
//                                for (int i = 0; i < states.length; i++) {
//                                    if (states[i] == android.R.attr.state_focused || states[i] == android.R.attr.state_enabled) {
//                                        GradientDrawable d = (GradientDrawable) bgShape.getCurrent();
//                                        d.setColor(Color.parseColor(cs.getAndroidColor()));
//                                    }
//                                }
//                                bgShape = (StateListDrawable) btn_showMain.getBackground();
//                                states = bgShape.getState();
//                                for (int i = 0; i < states.length; i++) {
//                                    if (states[i] == android.R.attr.state_focused || states[i] == android.R.attr.state_enabled) {
//                                        GradientDrawable d = (GradientDrawable) bgShape.getCurrent();
//                                        d.setColor(Color.parseColor(cs.getAndroidColor()));
//                                    }
//                                }
//                                btn_table.setTextColor(Color.parseColor(cs.getAndroidfontcolor()));
//                                btn_showMain.setTextColor(Color.parseColor(cs.getAndroidfontcolor()));
//                            }
//                            //break;
//                        }
//                    }
//                    break;
//            }
//        }
        }
    }

    public int getStyle() {
        return style;
    }

    public void setStyle(int style) {
        this.style = style;
    }

    private OnItemClickListener mOnItemClickListener;

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        mOnItemClickListener = onItemClickListener;
    }

    public interface OnItemClickListener {

        void onItemClick(TableBean.DataBean datasBean, int position);

    }
}
