package com.gingersoft.gsa.cloud.base.order.bean.mealManger;


import com.gingersoft.gsa.cloud.base.table.bean.TableBean;

import lombok.Data;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-01-09
 * 修订历史：2020-01-09
 * 描述：保存開台返回的訂單數據
 */
@Data
public class OpenTableManage {

    private String TAG = getClass().getSimpleName();
    private static OpenTableManage sDefaultOpenTableManage;

    //開台信息
    private TableBean.DataBean tableBean;
    //使用狀態
    private int useStatus;
    //開台人數
    private int peopleNumber = 0;
    //是否分檯
    private boolean isSplite = false;
    //分檯編號
    private String splitNo;

    public static OpenTableManage getDefault() {
        if (sDefaultOpenTableManage == null) {
            sDefaultOpenTableManage = new OpenTableManage();
        }
        return sDefaultOpenTableManage;
    }

    public void clear() {
        tableBean = null;
        peopleNumber = 0;
        isSplite = false;
        splitNo = "";
    }

}
