package com.gingersoft.gsa.cloud.main.mvp.model;

import android.app.Application;

import com.gingersoft.gsa.cloud.base.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.main.mvp.contract.ExpandListContract;
import com.gingersoft.gsa.cloud.main.mvp.model.bean.FunctionBean;
import com.gingersoft.gsa.cloud.main.mvp.model.service.ExpandListService;
import com.google.gson.Gson;
import com.jess.arms.di.scope.ActivityScope;
import com.jess.arms.integration.IRepositoryManager;
import com.jess.arms.mvp.BaseModel;

import javax.inject.Inject;

import io.reactivex.Observable;


@ActivityScope
public class ExpandListModel extends BaseModel implements ExpandListContract.Model {
    @Inject
    Gson mGson;
    @Inject
    Application mApplication;

    @Inject
    public ExpandListModel(IRepositoryManager repositoryManager) {
        super(repositoryManager);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mGson = null;
        this.mApplication = null;
    }


    @Override
    public Observable<BaseResult> getExpandList(int restaurantId) {
        return mRepositoryManager.obtainRetrofitService(ExpandListService.class).getExpandList(restaurantId);
    }
}