package com.gingersoft.supply_chain.mvp.ui.adapter;

import android.content.Context;
import android.view.View;
import android.widget.LinearLayout;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.common.utils.MoneyUtil;
import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.mvp.bean.OrderDetailsBean;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/12/24
 * Time: 9:07
 * Use:
 */
public class OrderDetailsFoodAdapter extends BaseQuickAdapter<OrderDetailsBean.PurchaseOrderDetailsInfoVosBean, BaseViewHolder> {

    private Context context;

    public OrderDetailsFoodAdapter(Context context, @Nullable List<OrderDetailsBean.PurchaseOrderDetailsInfoVosBean> data) {
        super(R.layout.item_order_details_food, data);
        this.context = context;
    }

    @Override
    protected void convert(@NotNull BaseViewHolder viewHolder, OrderDetailsBean.PurchaseOrderDetailsInfoVosBean item) {
        viewHolder.setText(R.id.tv_order_details_item_food_name, item.getName());
        viewHolder.setText(R.id.tv_order_details_item_purchasing_unit, item.getUnit_content());
        viewHolder.setText(R.id.tv_order_details_item_purchasing_unit_price, String.valueOf(item.getFoodPrice()));
        viewHolder.setText(R.id.tv_order_details_item_num, String.valueOf(item.getFoodQuantity()));
        //保存下來總價，用於計算所有食品的總價
        item.setTotalAmount(MoneyUtil.priceCalculation(item.getFoodPrice(), item.getFoodQuantity()));
        viewHolder.setText(R.id.tv_order_details_item_purchasing_total_amount, String.valueOf(item.getTotalAmount()));
        //入庫單價
//        viewHolder.setText(R.id.tv_order_details_item_warehouse_total_amount, item.get);

//        LinearLayout warehouseUnitLayout = viewHolder.getView(R.id.layout_warehouse_unit);
//        View view = View.inflate(context, R.layout.item_order_details_food, null);
//        warehouseUnitLayout.addView(view);

        viewHolder.setBackgroundResource(R.id.iv_order_details_item_food_select, item.isChecked() ? R.drawable.ic_checkbox_checked : R.drawable.ic_checkbox_uncheck);
    }
}
