package com.gingersoft.gsa.cloud.pay.pos;

import android.app.Activity;
import android.content.Context;

import com.etps.aca.lib.util.CommandUtil;
import com.gingersoft.gsa.cloud.pay.contract.PayErrorCode;
import com.gingersoft.gsa.cloud.pay.pos.bean.PosMatter;
import com.gingersoft.gsa.cloud.pay.pos.hywebpos.bean.response.pos.HywebPosResponse;
import com.gingersoft.gsa.cloud.pay.pos.hywebpos.constant.PayStatusCode;
import com.gingersoft.gsa.cloud.pay.widget.StatusLoadingDialog;
import com.jess.arms.mvp.IView;


/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2019/6/13
 * 修订历史：2019/6/13
 * 描述：
 */
public abstract class IPosAction {

    protected Context mContext;
    protected IView mView;
    protected PosAction mPosAction;
    protected OnPosActionListener mOnPosActionListener;

    protected StatusLoadingDialog mStatusLoadingDialog;

    private final String mLoadingActionText = "中...";
    private final String mLoadingActionComplteText = "成功";

    private final long mCancelDelayMillis = 1000;

    public IPosAction(Context context, IView iView, PosAction action, boolean showLoading) {
        this.mContext = context;
        this.mView = iView;
        this.mPosAction = action;
        if (showLoading) {
            mStatusLoadingDialog = new StatusLoadingDialog(context, action.getActionName() + mLoadingActionText, mCancelDelayMillis);
            mStatusLoadingDialog.show();
        }
    }

    /**
     * 對POS幾發起請求前的業務處理,如將操作記錄添加到後台日誌表，事項表
     */
    protected abstract void onRequestBefore();


    /**
     * 像POS發起請求的方法
     */
    protected void onRequestPOS(String requestJson) {
        CommandUtil.sendRequest(mContext, requestJson);
    }

    /**
     * POS回調成功的方法
     *
     * @param posResponse
     */
    public void onActionComplte(Context context, HywebPosResponse posResponse, Activity originalActivity) {
        if (mStatusLoadingDialog != null) {
            mStatusLoadingDialog.setStatusText(mPosAction.getActionName() + mLoadingActionComplteText);
            mStatusLoadingDialog.loadSuccess();
        }
    }

    /**
     * POS回調失敗的方法
     *
     * @param e
     */
    public void onActionError(Exception e) {
        if (mStatusLoadingDialog != null) {
            mStatusLoadingDialog.setStatusText(e.getMessage());
            mStatusLoadingDialog.loadFailure();
        }
        if (e.getMessage().contains(PayErrorCode.pos_response_null)) {
            if (mOnPosActionListener != null) {
                mOnPosActionListener.onResponseNull();
            }
        }
    }

    protected void canCelLoadingDialog() {
        if (mStatusLoadingDialog != null) {
            mStatusLoadingDialog.cancel();
        }
    }

    /**
     * 根據Pos事件類型獲取業務類型
     *
     * @param eventName
     * @return
     */
    protected String getActionNameByEventName(String eventName) {
        switch (eventName) {
            case com.etps.aca.lib.constant.Constant.EVENT.NAME.SALE_RESP:
                return PosAction.SALE.getActionName();
            case com.etps.aca.lib.constant.Constant.EVENT.NAME.VOID_RESP:
                return PosAction.VOID.getActionName();
            case com.etps.aca.lib.constant.Constant.EVENT.NAME.REFUND_RESP:
                return PosAction.RETRIEVAL.getActionName();
            case com.etps.aca.lib.constant.Constant.EVENT.NAME.ADJUST_RESP:
                return PosAction.TIP.getActionName();
            case "RETRIEVAL_RESP":
                return PosAction.RETRIEVAL.getActionName();
            case "SETTLE_RESP":
                return PosAction.SETTLEMENT.getActionName();

        }
        return "未知動作";
    }

    /**
     * 根據業務回調狀態，返回事項上傳狀態
     *
     * @param status
     * @return
     */
    protected byte getPosMatterStatus(String status) {
        switch (status) {
            case PayStatusCode.PAY_STATUS_00:
                return PosMatter.status_0;
            default:
                return PosMatter.status_2;
        }
    }


}
