package com.gingersoft.supply_chain.mvp.bean;

import com.gingersoft.supply_chain.mvp.content.Constant;

import java.io.Serializable;
import java.util.List;

import lombok.Data;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/12/4
 * Time: 11:41
 * Use:食材信息
 */
@Data
public class PurchaseFoodListVosBean implements Serializable {
    private static final long serialVersionUID = 7084280906070243339L;
    private int id;
    private String supplierName;
    private String images;
    private String foodNo;
    private String name;

    private double unitPrice;
    private String foodCategoryName;
    private String remarks;
    private int quantityStarts;
    private int quantityEnd;
    private int type;
    private String unitContent;
    private long createTime;
    private int foodQuantity;
    /**
     * 分類id
     */
    private int categoryId;
    /**
     * 所屬供應商id
     */
    private int supplierId;
    /**
     * 是否選中
     */
    private boolean isChecked;
    /**
     * 是否刪除
     * {@link Constant.DELETE,Constant.NORMAL}
     *
     */
    private int deletes;
    private int restaurantId;
    private int brandId;
    private InventoryAlarm inventoryAlarm;
    @Data
    public static class InventoryAlarm {
        //庫存預警，單位id
        private int foodUnitId;
        //最低庫存
        private int minimumInventory;
    }
    //包裝規格
    private List<FoodPackingSpecificationBean> foodPackingSpecifications;



    public boolean isChecked() {
        return isChecked;
    }

    public void setChecked(boolean checked) {
        isChecked = checked;
    }
}
