package com.gingersoft.gsa.cloud.table.mvp.model.table.action;

import android.app.Activity;

import com.gingersoft.gsa.cloud.common.core.table.TableBean;
import com.gingersoft.gsa.cloud.table.R;
import com.qmuiteam.qmui.widget.dialog.QMUIDialog;
import com.qmuiteam.qmui.widget.dialog.QMUIDialogAction;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-09-23
 * 修订历史：2020-09-23
 * 描述：餐檯模式-重置餐檯{@link com.gingersoft.gsa.cloud.table.mvp.ui.activity.TableActivity}
 */
public class ResetTableAction extends TableAction {

    public ResetTableAction(Activity context) {
        super(context, "重置餐檯", "請選擇需要重置的檯號", "");
    }

    @Override
    public void action(TableBean.DataBean dataBean) {
        setOperatContentText(dataBean.getTableName());
        if (dataBean.getSplitStatus() == 1) {
            showSplitTableDialogAction();
        } else {
            showActionTipDialog(dataBean);
        }
    }

    @Override
    public boolean filterTableCondition(TableBean.DataBean dataBean) {
        return dataBean.getUseStatus() == 1 || dataBean.getSplitStatus() == 1;
    }

    @Override
    public void destroy() {
    }

    public void showActionTipDialog(TableBean.DataBean dataBean) {
        QMUIDialog.MessageDialogBuilder dialogBuilder = new QMUIDialog.MessageDialogBuilder(mContext);
        dialogBuilder.setTitleIcon(R.drawable.qmui_icon_dialog_doubt);
        dialogBuilder.setMessage("是否確認重置" + dataBean.getTableName() + "號檯?");
        dialogBuilder.addAction(0, "確認", QMUIDialogAction.ACTION_PROP_NEGATIVE, new QMUIDialogAction.ActionListener() {
            @Override
            public void onClick(QMUIDialog dialog, int index) {
                dialog.dismiss();
                resetTable(dataBean);
            }
        });
        dialogBuilder.addAction("取消", new QMUIDialogAction.ActionListener() {
            @Override
            public void onClick(QMUIDialog dialog, int index) {
                dialog.dismiss();
                cancel();
            }
        });
        dialogBuilder.create(R.style.MyDialogTheme2).show();
    }
}
