package com.gingersoft.gsa.cloud.ui.adapter.multi;

import android.content.Context;
import android.text.Editable;
import android.text.TextWatcher;
import android.widget.EditText;

import com.chad.library.adapter.base.provider.BaseItemProvider;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.common.utils.other.TextUtil;
import com.gingersoft.gsa.cloud.ui.R;
import com.gingersoft.gsa.cloud.ui.bean.InfoMultiBean;
import com.gingersoft.gsa.cloud.ui.bean.MultiInputSelectBean;

import org.jetbrains.annotations.NotNull;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/11/25
 * Time: 10:02
 * Use: 多個輸入框, 例如：供應鏈選擇包裝規格
 */
public class MultipleInputProvider<T extends InfoMultiBean> extends BaseItemProvider<T> {
    private Context context;

    public MultipleInputProvider(Context context) {
        this.context = context;
    }

    @Override
    public int getItemViewType() {
        return InfoMultiBean.ITEM_MULTIPLE_INPUT_SELECT;
    }

    @Override
    public int getLayoutId() {
        return R.layout.item_multi_input_select;
    }

    @Override
    public void convert(@NotNull BaseViewHolder baseViewHolder, T t) {
        if (t instanceof MultiInputSelectBean) {
            MultiInputSelectBean multiInputSelectBean = (MultiInputSelectBean) t;
            //是否顯示必選
            baseViewHolder.setGone(R.id.multi_required, !multiInputSelectBean.isRequired());
            //設置標題
            if (TextUtil.isNotEmptyOrNullOrUndefined(multiInputSelectBean.getShowTitle())) {
                baseViewHolder.setText(R.id.tv_multi_title, multiInputSelectBean.getShowTitle());
            } else {
                baseViewHolder.setText(R.id.tv_multi_title, "");
            }

            EditText edFirst = baseViewHolder.getView(R.id.ed_multi_value_first);
            initEditText(edFirst, multiInputSelectBean.getShowValue(), multiInputSelectBean.getHintText());
            edFirst.addTextChangedListener(new TextWatcher() {
                @Override
                public void beforeTextChanged(CharSequence s, int start, int count, int after) {

                }

                @Override
                public void onTextChanged(CharSequence s, int start, int before, int count) {

                }

                @Override
                public void afterTextChanged(Editable s) {
                    multiInputSelectBean.setShowValue(s + "");
                }
            });

            EditText edSecond = baseViewHolder.getView(R.id.ed_multi_value_second);
            initEditText(edSecond, multiInputSelectBean.getShowValueSecond(), multiInputSelectBean.getHintTextSecond());

            edFirst.addTextChangedListener(new TextWatcher() {
                @Override
                public void beforeTextChanged(CharSequence s, int start, int count, int after) {

                }

                @Override
                public void onTextChanged(CharSequence s, int start, int before, int count) {

                }

                @Override
                public void afterTextChanged(Editable s) {
                    multiInputSelectBean.setShowValueSecond(s + "");
                }
            });

            EditText edThird = baseViewHolder.getView(R.id.ed_multi_value_third);
            initEditText(edThird, multiInputSelectBean.getShowValueThird(), multiInputSelectBean.getHintTextThird());
            edThird.addTextChangedListener(new TextWatcher() {
                @Override
                public void beforeTextChanged(CharSequence s, int start, int count, int after) {

                }

                @Override
                public void onTextChanged(CharSequence s, int start, int before, int count) {

                }

                @Override
                public void afterTextChanged(Editable s) {
                    multiInputSelectBean.setShowValueThird(s + "");
                }
            });

            setFilters(edFirst, multiInputSelectBean);
            setFilters(edSecond, multiInputSelectBean);
            setFilters(edThird, multiInputSelectBean);
        }
    }

    private void initEditText(EditText tvThird, String showValue, String hintText) {
        if (TextUtil.isNotEmptyOrNullOrUndefined(showValue)) {
            tvThird.setText(showValue);
        } else if (TextUtil.isNotEmptyOrNullOrUndefined(hintText)) {
            tvThird.setHint(hintText);
        } else {
            tvThird.setText("");
        }
    }

    private void setFilters(EditText editText, MultiInputSelectBean multiInputSelectBean){
        if (multiInputSelectBean.getInputFilters() != null) {
            editText.setFilters(multiInputSelectBean.getInputFilters());
        } else {
            editText.setFilters(editText.getFilters());
        }

        if (multiInputSelectBean.getInputType() != -1) {
            editText.setInputType(multiInputSelectBean.getInputType());
        } else {
            editText.setInputType(editText.getInputType());
        }
    }
}

