package com.gingersoft.gsa.other_order_mode.ui.fragment

import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.Button
import androidx.lifecycle.Observer
import androidx.lifecycle.ViewModelProvider
import androidx.recyclerview.widget.LinearLayoutManager
import com.gingersoft.gsa.cloud.base.application.GsaCloudApplication
import com.gingersoft.gsa.cloud.ui.utils.AppDialog
import com.gingersoft.gsa.other_order_mode.R
import com.gingersoft.gsa.other_order_mode.model.viewModel.DeliveryViewModel
import com.gingersoft.gsa.other_order_mode.ui.activity.DeliverySettingActivity
import com.gingersoft.gsa.other_order_mode.ui.adapter.DeliveryListAdapter
import com.gingersoft.gsa.other_order_mode.ui.base.BaseFragment
import com.gingersoft.gsa.other_order_mode.util.InjectorUtil
import com.gingersoft.gsa.other_order_mode.util.setState
import kotlinx.android.synthetic.main.fragment_delivery_list.*

class DeliveryFragment : BaseFragment() {

    var deliveryListAdapter: DeliveryListAdapter? = null

    private val viewModel by lazy { ViewModelProvider(activity?.viewModelStore!!, InjectorUtil.getDeliveryFactory())[DeliveryViewModel::class.java] }

    private lateinit var addBtn: Button

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?,
                              savedInstanceState: Bundle?): View? {
        val contentView = inflater.inflate(R.layout.fragment_delivery_list, container, false)
        addBtn = contentView.findViewById(R.id.btn_default)
        return contentView
    }

    override fun onActivityCreated(savedInstanceState: Bundle?) {
        super.onActivityCreated(savedInstanceState)
//        childFragmentManager.beginTransaction().remove(this).add(null, "").addToBackStack(null).commit()
        addBtn.text = "+添加配送方式"
        addBtn.setOnClickListener {
            (activity as DeliverySettingActivity).editDelivery(null)
        }

        viewModel.otherInfo.observe(viewLifecycleOwner, Observer { it ->
            if (it?.data?.list != null && it.data.list.isNotEmpty()) {
                if (deliveryListAdapter == null) {
                    deliveryListAdapter = DeliveryListAdapter(context!!, it.data.list)
                    rv_delivery.adapter = deliveryListAdapter
                    rv_delivery.layoutManager = LinearLayoutManager(context!!)
                } else {
                    deliveryListAdapter!!.setNewData(it.data.list)
                }
                deliveryListAdapter!!.setOnItemChildClickListener { adapter, view, position ->
                    when (view.id) {
                        R.id.iv_delete -> {
                            AppDialog().showWaringDialog(context, "是否確認刪除") { _, dialog ->
                                showLoading()
                                it.data.list[position].apply {
                                    viewModel.updateDeliveryConfig(distributionFeeMin.toString(), distributionFeeMax.toString(), distributionFee.toString(), deliveryCost.toString(), distributionType, type, desc, id, GsaCloudApplication.getRestaurantId(context), GsaCloudApplication.getMemberId(context), lackPrice.toString(), 1) {
                                        dialog.dismiss()
                                        cancelDialogForLoading()
                                    }
                                }
                            }
                        }//刪除
                        else -> {
                            (activity as DeliverySettingActivity).editDelivery(it.data.list[position])
                        }//查看詳情---編輯
                    }
                }
                rv_delivery.setState(true)
            } else {
                rv_delivery.setState(false)
            }
        })

        viewModel.queryDeliveryList(GsaCloudApplication.getRestaurantId(activity!!).toString())
    }

}
