package com.gingersoft.gsa.cloud.login.mvp.ui.activity.mvp.ui.activity;

import android.content.Intent;
import android.os.Bundle;
import android.widget.Button;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.gingersoft.gsa.cloud.common.core.user.UserContext;
import com.gingersoft.gsa.cloud.app.GsaCloudApplication;
import com.gingersoft.gsa.cloud.common.utils.other.SPUtils;
import com.gingersoft.gsa.cloud.common.utils.toast.ToastUtils;
import com.gingersoft.gsa.cloud.common.constans.HttpsConstans;
import com.gingersoft.gsa.cloud.login.R;
import com.gingersoft.gsa.cloud.login.R2;
import com.gingersoft.gsa.cloud.login.di.component.DaggerSwitchServerComponent;
import com.gingersoft.gsa.cloud.login.mvp.contract.SwitchServerContract;
import com.gingersoft.gsa.cloud.login.mvp.presenter.SwitchServerPresenter;
import com.jess.arms.base.BaseActivity;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.utils.ArmsUtils;

import butterknife.BindView;

import static com.jess.arms.utils.Preconditions.checkNotNull;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 02/29/2020 20:49
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public class SwitchServerActivity extends BaseActivity<SwitchServerPresenter> implements SwitchServerContract.View {

    @BindView(R2.id.radioGroup)
    RadioGroup radioGroup;
    @BindView(R2.id.rb_server_hk)
    RadioButton rbHK;
    @BindView(R2.id.rb_server_formal)
    RadioButton rbFormal;
    @BindView(R2.id.rb_youchang)
    RadioButton rb_youchang;
    @BindView(R2.id.rb_shiwei)
    RadioButton rb_shiwei;
    @BindView(R2.id.rb_shishu)
    RadioButton rb_shishu;
    @BindView(R2.id.btn_switch_server)
    Button switchServer;
    @BindView(R2.id.tv_now_server)
    TextView tvNowServer;

    private int[] rbIds = new int[]{R.id.rb_server_hk, R.id.rb_server_formal, R.id.rb_youchang, R.id.rb_shiwei, R.id.rb_shishu};
    private int selectIndex;

    @Override
    public void setupActivityComponent(@NonNull AppComponent appComponent) {
        DaggerSwitchServerComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public int initView(@Nullable Bundle savedInstanceState) {
        return R.layout.activity_switch_server; //如果你不需要框架帮你设置 setContentView(id) 需要自行设置,请返回 0
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
        String nowServer = HttpsConstans.ROOT_SERVER_ADDRESS_FORMAL;
        tvNowServer.setText("當前服務器：" + nowServer);
        ((RadioButton) radioGroup.getChildAt(HttpsConstans.isFormal)).setChecked(true);

        radioGroup.setOnCheckedChangeListener((group, checkedId) -> selectIndex = group.indexOfChild(findViewById(checkedId)));
        switchServer.setOnClickListener(v -> {
            SPUtils.put("isFormal", selectIndex);

            UserContext.newInstance().logOut();
//            GsaCloudApplication.logOut();
            ToastUtils.show(mContext, "已切換環境，重啟生效" + selectIndex);
            GsaCloudApplication.initDomainUrl();
            finish();
            startActivity(new Intent(mContext, LoginActivity.class));
        });
    }

    @Override
    public void initIntent() {

    }

    @Override
    public void initTopBar() {

    }

    @Override
    public void initLanguage() {

    }

    @Override
    public void initLayoutParams() {

    }

    @Override
    public void initLayoutVisible() {

    }


    @Override
    public void showLoading(String message) {

    }

    @Override
    public void hideLoading() {

    }

    @Override
    public void showMessage(@NonNull String message) {
        checkNotNull(message);
        ArmsUtils.snackbarText(message);
    }

    @Override
    public void launchActivity(@NonNull Intent intent) {
        checkNotNull(intent);
        ArmsUtils.startActivity(intent);
    }

    @Override
    public void killMyself() {
        finish();
    }
}
