package com.gingersoft.gsa.cloud.table.mvp.model.bean;

import android.text.TextUtils;

import java.io.File;

import lombok.Getter;
import lombok.Setter;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-04-30
 * 修订历史：2020-04-30
 * 描述：
 */
@Getter
@Setter
public class SoldoutCtrFood {

    private long id;
    private int restaurantId;
    private long brandId;
    private Long foodId;
    private Long modifierId;
    /**
     * 1-食品組
     * 2-食品
     * 3-細項
     **/
    private byte type;
    /**
     * 庫存數量
     */
    private int remainingNumber = -999999999;
    /**
     * 使用數量
     */
    private int useNumber = -999999999;
    private String foodName;
    private String foodName1;
    private String foodName2;

    /**
     * 自定義字段
     */
    /**
     * 是否已暫停
     */
    private boolean isStop = false;
    private int selected;

    public String getQtyName() {
        if (isStop) {
            return "暫停";
        }
        if (remainingNumber == 0) {
            return "";
        }
        if (useNumber == -999999999) {
            useNumber = 0;
        }
        if (remainingNumber - useNumber > 0) {
            return String.valueOf(remainingNumber - useNumber);
        }
        if (remainingNumber - useNumber == 0) {
            return "售罄";
        }
        return "";
    }

    public SoldoutCtrFood() {
    }

    public SoldoutCtrFood(SoldoutCtrFood ctrFood) {
        this.id = ctrFood.id;
        this.restaurantId = ctrFood.restaurantId;
        this.brandId = ctrFood.brandId;
        this.foodId = ctrFood.foodId;
        this.modifierId = ctrFood.modifierId;
        this.type = ctrFood.type;
        this.remainingNumber = ctrFood.remainingNumber;
        this.useNumber = ctrFood.useNumber;
        this.foodName = ctrFood.foodName;
        this.foodName1 = ctrFood.foodName1;
        this.foodName2 = ctrFood.foodName2;
        this.isStop = ctrFood.isStop;
        this.selected = ctrFood.selected;
    }

    public String getName(){
        if(!TextUtils.isEmpty(foodName)){
            return foodName;
        }
        if(!TextUtils.isEmpty(foodName1)){
            return foodName1;
        }
        if(!TextUtils.isEmpty(foodName2)){
            return foodName2;
        }
        return "";
    }
}
