package com.gingersoft.gsa.cloud.table.mvp.model.bean.response;

import android.text.TextUtils;

import androidx.annotation.Nullable;

import com.gingersoft.gsa.cloud.common.core.member.MemberInfo;
import com.gingersoft.gsa.cloud.common.core.table.TableBean;
import com.gingersoft.gsa.cloud.order.bean.response.OrderDiscountResponse;
import com.gingersoft.gsa.cloud.order.bean.response.OrderResponse;
import com.gingersoft.gsa.cloud.pay.bean.PayMethod;
import com.gingersoft.gsa.cloud.pay.pos.hywebpos.constant.PayMethodConstant;

import java.io.Serializable;
import java.util.List;

import lombok.Data;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-03-14
 * 修订历史：2020-03-14
 * 描述：已結賬訂單
 */
@Data
public class OrderManagerResponse implements Serializable {

    /**
     * id : 47040
     * tableName : 4
     * tableId : 1694
     * orderNo : gs200371144969589
     * status : 0
     * totalAmount : 10
     * totalPoints : 0
     * amount : 15
     * createTime : Mar 14, 2020 1:24:12 PM
     * endTime : Mar 14, 2020 1:24:12 PM
     * person : 2
     * payName : 支付寶
     * orderPayType : 0
     * tipsPrice : 5
     * linePayType : 1
     * orderDetails : [{"id":1639952,"orderId":47040,"parentId":0,"productName":"包子","productId":"14520","price":5,"lunchboxPrice":0,"number":1,"type":3,"createTime":"Mar 14, 2020 2:55:02 PM","status":0},{"id":1639953,"orderId":47040,"parentId":0,"productName":"燒麥","productId":"14522","price":5,"lunchboxPrice":0,"number":1,"type":3,"createTime":"Mar 14, 2020 2:55:02 PM","status":0}]
     */
    private long id;
    private int status;
    private String orderNo;
    private String tableName;
    private String tableNumber;
    private int tableId;
    private int person;
    /**
     * 订单类型
     * 1：堂食
     * 2：外賣
     * 3：掃碼點餐
     * 5：預點餐
     * 7：自取
     */
    private int orderType;
    /**
     * 總金額
     */
    private double totalAmount;
    private int totalPoints;
    /**
     * 支付金額
     */
    private double amount;
    /**
     * 賬單小數
     */
    private Double rounding;
    /**
     * 服務費
     */
    private Double serviceAmount;
    /**
     * 訂單碼
     */
    private String billNo;
    /**
     * 取餐碼
     */
    private String takeFoodCode;

    /**
     * 生成訂單時間
     */
    private String createTime;
    /**
     * 結賬時間
     */
    private String endTime;

    /**
     * 訂單食品詳情
     */
    private List<OrderResponse.OrderDetailsBean> orderDetails;
    /**
     * 折扣詳情
     */
    private List<OrderDiscountResponse> discountDetails;
    /**
     * 支付詳情
     */
    private List<OrderPayBean> orderPays;
    /**
     * 餐檯信息
     */
    private TableBean.DataBean restaurantTable;
    /**
     * 會員信息
     */
    private MemberInfo memberInfo;
    /**
     * 會員積分碼
     */
    private String verifyCode;
    /**
     * 會員積分相关实体
     */
    private OrderPayResponse integralInfo;

    /**
     * N5相關,以下哪個參數不為Null說明為當前支付狀態
     */
    /**
     * N5 支付TXN_ID
     */
    private String payTxnId;
    /**
     * N5取消支付TXN_ID
     */
    private String cancelTxnId;
    /**
     * N5退款Refund_Id
     */
    private String refundTxnId;

    /**
     * 清機ID,已清機則不為null
     */
    private Integer restaurantOperationId;

    /**
     * 事項狀態 0：異常未處理，1： 成功
     */
    private int matterStatus = 1;
    /**
     * 設備ID，用來區分每台N5設備支付的訂單
     */
    private String deviceId;

    /**
     * 訂單狀態:0:未支付;1:待確認(已支付, 待餐廳確認);2:制作中（餐厅确认）;3:派送中;4:确认收货（完成）;5:是否评论;6:取消;
     */
    public static final byte STATUS_UNPAID = 0;
    public static final byte STATUS_NOT_CONFIRM = 1;
    public static final byte STATUS_Making = 2;
    public static final byte STATUS_Dispatching = 3;
    public static final byte STATUS_CONFIRM = 4;
    public static final byte STATUS_COMMENT = 5;
    public static final byte STATUS_CANCEL = 6;

    /**
     * 订单类型1：堂食2：外賣3：掃碼點餐5：預點餐7：自取
     */
    public static final byte ORDER_TYPE_DOSHOKU = 1;
    public static final byte ORDER_TYPE_TAKEAWAY = 2;
    public static final byte ORDER_TYPE_SELFCOLLECTION = 7;

    /**
     * 是否選中
     */
    private boolean checked = false;

    public boolean withHywebPay() {
        if (!TextUtils.isEmpty(payTxnId) || !TextUtils.isEmpty(cancelTxnId) || !TextUtils.isEmpty(refundTxnId)) {
            return true;
        }
        return false;
    }

    @Data
    public static final class OrderPayBean implements Serializable {
        private long id;
        private long lineOrderId;
        private int payType;
        private String payTime;
        private double amount;
        private double tipsPrice;
        private int status;
        private int linePayType;
        /**
         * 0=非營業額(非收入)
         * 1=營業額(收入)
         * 2=非項目銷售(Non gross item, 獨佔的支付方式)
         */
        private int paySales;
        private String payName;

        public boolean withHywebPay() {
            if (payType == PayMethod.HYWEB_POS_TYPE_CC || payType == PayMethod.HYWEB_POS_TYPE_QRC) {
                return true;
            }
            return false;
        }

        public String getHywebPayMethodByType() {
            if (payType == PayMethod.HYWEB_POS_TYPE_CC) {
                return PayMethodConstant.PAY_TYPE_CC;
            }
            if (payType == PayMethod.HYWEB_POS_TYPE_QRC) {
                return PayMethodConstant.PAY_TYPE_QRC;
            }
            return "";
        }
    }
}
