package com.joe.print.mvp.model;

import android.app.Application;

import com.gingersoft.gsa.cloud.common.bean.BaseResult;
import com.google.gson.Gson;
import com.jess.arms.integration.IRepositoryManager;
import com.jess.arms.mvp.BaseModel;
import com.jess.arms.di.scope.ActivityScope;
import javax.inject.Inject;
import com.joe.print.mvp.contract.PrintAddCurrencyContract;
import com.joe.print.mvp.model.server.PrintInfoService;

import io.reactivex.Observable;
import okhttp3.RequestBody;


@ActivityScope
public class PrintAddCurrencyModel extends BaseModel implements PrintAddCurrencyContract.Model {
    @Inject
    Gson mGson;
    @Inject
    Application mApplication;

    @Inject
    public PrintAddCurrencyModel(IRepositoryManager repositoryManager) {
        super(repositoryManager);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mGson = null;
        this.mApplication = null;
    }

    @Override
    public Observable<BaseResult> getPrinterCurrencyList(String restaurantId) {
        return mRepositoryManager.obtainRetrofitService(PrintInfoService.class).getCurrencyPrenterList(restaurantId);
    }

    @Override
    public Observable<BaseResult> addPrinterCurrency(RequestBody requestBody, boolean isUpdate) {
        if (isUpdate) {
            return mRepositoryManager.obtainRetrofitService(PrintInfoService.class).updatePrinterCurrency(requestBody);
        } else {
            return mRepositoryManager.obtainRetrofitService(PrintInfoService.class).addCurrencyPrenter(requestBody);
        }
    }
}