package com.gingersoft.supply_chain.di.component;

import dagger.BindsInstance;
import dagger.Component;

import com.jess.arms.di.component.AppComponent;

import com.gingersoft.supply_chain.di.module.WareHouseListModule;
import com.gingersoft.supply_chain.mvp.contract.WareHouseListContract;

import com.jess.arms.di.scope.FragmentScope;
import com.gingersoft.supply_chain.mvp.ui.fragment.warehouse.WareHouseListFragment;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 01/06/2021 15:37
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@FragmentScope
@Component(modules = WareHouseListModule.class, dependencies = AppComponent.class)
public interface WareHouseListComponent {
    void inject(WareHouseListFragment fragment);

    @Component.Builder
    interface Builder {
        @BindsInstance
        WareHouseListComponent.Builder view(WareHouseListContract.View view);

        WareHouseListComponent.Builder appComponent(AppComponent appComponent);

        WareHouseListComponent build();
    }
}