package com.gingersoft.gsa.cloud.base.application;

import android.content.Context;

import com.billy.cc.core.component.CC;
import com.gingersoft.gsa.cloud.base.common.bean.CurrentAndroidSetting;
import com.gingersoft.gsa.cloud.base.utils.constans.UserConstans;
import com.gingersoft.gsa.cloud.base.utils.crash.AppCrashHandler;
import com.gingersoft.gsa.cloud.base.utils.other.SPUtils;
import com.gingersoft.gsa.cloud.database.DaoManager;
import com.jess.arms.base.BaseApplication;

/**
 * Created by Wyh on 2019/12/21.
 */
public class GsaCloudApplication extends BaseApplication {

    /**
     * 系统上下文
     */
    private static Context mAppContext;

    public static boolean isLogin = false;
    public static CurrentAndroidSetting androidSetting;
    public static String userName = "";

    @Override
    public void onCreate() {
        super.onCreate();
        this.mAppContext = this;

        CC.enableVerboseLog(true);
        CC.enableDebug(true);
        CC.enableRemoteCC(true);

        initGreenDao();

        AppCrashHandler.getInstance().init(this, "test");
        androidSetting = new CurrentAndroidSetting();
    }


    private void initGreenDao() {
        DaoManager mManager = DaoManager.getInstance();
        mManager.init(this);
    }

    @Override
    protected void attachBaseContext(Context base) {
        super.attachBaseContext(base);
    }


    /**
     * 获取系统上下文：用于ToastUtil类
     */
    public static Context getAppContext() {
        return mAppContext;
    }


    //获取登陆token
    public static String getLoginToken(Context context) {
        return (String) SPUtils.get(context, UserConstans.token, "");
    }

    public static int getMemberId(Context context) {
        return (int) SPUtils.get(context, UserConstans.memberId, 0);
    }

    public static int getRestaurantId(Context context) {
        return (int) SPUtils.get(context, UserConstans.restaurantId, 0);
    }

    public static void setLoginToken(Context context, String token) {
        SPUtils.put(context, UserConstans.token, token);
    }

    public static void setMemberId(Context context, int memberId) {
        SPUtils.put(context, UserConstans.memberId, memberId);
    }

    public static String getMemberName(Context context) {
        return (String) SPUtils.get(context, UserConstans.memberName, "");
    }

    public static void setMemberName(Context context, String memberName) {
        SPUtils.put(context, UserConstans.memberName, memberName);
    }

    public static void setRestaurantId(Context context, int restaurantId) {
        SPUtils.put(context, UserConstans.restaurantId, restaurantId);
    }
}
