package com.gingersoft.gsa.cloud.database.greendao;

import java.util.List;
import android.database.Cursor;
import android.database.sqlite.SQLiteStatement;

import org.greenrobot.greendao.AbstractDao;
import org.greenrobot.greendao.Property;
import org.greenrobot.greendao.internal.DaoConfig;
import org.greenrobot.greendao.database.Database;
import org.greenrobot.greendao.database.DatabaseStatement;
import org.greenrobot.greendao.query.Query;
import org.greenrobot.greendao.query.QueryBuilder;

import com.gingersoft.gsa.cloud.database.bean.Modifier;

// THIS CODE IS GENERATED BY greenDAO, DO NOT EDIT.
/** 
 * DAO for table "MODIFIER".
*/
public class ModifierDao extends AbstractDao<Modifier, Long> {

    public static final String TABLENAME = "MODIFIER";

    /**
     * Properties of entity Modifier.<br/>
     * Can be used for QueryBuilder and for referencing column names.
     */
    public static class Properties {
        public final static Property Dbid = new Property(0, Long.class, "dbid", true, "_id");
        public final static Property Mid = new Property(1, Long.class, "mid", false, "MID");
        public final static Property TopId = new Property(2, Long.class, "topId", false, "TOP_ID");
        public final static Property RestaurantId = new Property(3, Long.class, "restaurantId", false, "RESTAURANT_ID");
        public final static Property ModifierName = new Property(4, String.class, "modifierName", false, "MODIFIER_NAME");
        public final static Property SeqNo = new Property(5, Long.class, "seqNo", false, "SEQ_NO");
        public final static Property MarketPrice = new Property(6, Double.class, "marketPrice", false, "MARKET_PRICE");
        public final static Property Price = new Property(7, Double.class, "price", false, "PRICE");
        public final static Property LunchboxPrice = new Property(8, Double.class, "lunchboxPrice", false, "LUNCHBOX_PRICE");
        public final static Property ColorId = new Property(9, Long.class, "colorId", false, "COLOR_ID");
        public final static Property ImageUrl = new Property(10, String.class, "imageUrl", false, "IMAGE_URL");
        public final static Property Invisible = new Property(11, Long.class, "invisible", false, "INVISIBLE");
        public final static Property Cost = new Property(12, Double.class, "cost", false, "COST");
        public final static Property StartDate = new Property(13, java.util.Date.class, "startDate", false, "START_DATE");
        public final static Property EndDate = new Property(14, java.util.Date.class, "endDate", false, "END_DATE");
        public final static Property Like = new Property(15, Long.class, "like", false, "LIKE");
        public final static Property TotalSold = new Property(16, Long.class, "totalSold", false, "TOTAL_SOLD");
        public final static Property MajorMainId = new Property(17, Long.class, "majorMainId", false, "MAJOR_MAIN_ID");
        public final static Property DeptId = new Property(18, Long.class, "deptId", false, "DEPT_ID");
        public final static Property CreateBy = new Property(19, String.class, "createBy", false, "CREATE_BY");
        public final static Property CreateTime = new Property(20, java.util.Date.class, "createTime", false, "CREATE_TIME");
        public final static Property UpdateBy = new Property(21, String.class, "updateBy", false, "UPDATE_BY");
        public final static Property UpdateTime = new Property(22, java.util.Date.class, "updateTime", false, "UPDATE_TIME");
        public final static Property PosFid = new Property(23, String.class, "posFid", false, "POS_FID");
        public final static Property PId = new Property(24, String.class, "pId", false, "P_ID");
        public final static Property AutoMod = new Property(25, Long.class, "autoMod", false, "AUTO_MOD");
        public final static Property BlueEdit = new Property(26, Long.class, "blueEdit", false, "BLUE_EDIT");
        public final static Property AutoMerge = new Property(27, Long.class, "autoMerge", false, "AUTO_MERGE");
        public final static Property CustomMsg = new Property(28, Long.class, "customMsg", false, "CUSTOM_MSG");
        public final static Property IsParent = new Property(29, Long.class, "isParent", false, "IS_PARENT");
        public final static Property ModifierName1 = new Property(30, String.class, "modifierName1", false, "MODIFIER_NAME1");
        public final static Property ModifierName2 = new Property(31, String.class, "modifierName2", false, "MODIFIER_NAME2");
        public final static Property Multiple = new Property(32, Double.class, "multiple", false, "MULTIPLE");
        public final static Property PrintSet = new Property(33, String.class, "printSet", false, "PRINT_SET");
        public final static Property KtSetting = new Property(34, String.class, "ktSetting", false, "KT_SETTING");
        public final static Property ModComm = new Property(35, Long.class, "modComm", false, "MOD_COMM");
        public final static Property ModTaste = new Property(36, Long.class, "modTaste", false, "MOD_TASTE");
        public final static Property ModMsg = new Property(37, Long.class, "modMsg", false, "MOD_MSG");
        public final static Property KtFireCourse = new Property(38, Long.class, "ktFireCourse", false, "KT_FIRE_COURSE");
        public final static Property AbleDisCount = new Property(39, Long.class, "ableDisCount", false, "ABLE_DIS_COUNT");
        public final static Property PrintToBill = new Property(40, Long.class, "printToBill", false, "PRINT_TO_BILL");
        public final static Property KtPrintMainItem = new Property(41, Long.class, "ktPrintMainItem", false, "KT_PRINT_MAIN_ITEM");
        public final static Property KtShowPrice = new Property(42, Long.class, "ktShowPrice", false, "KT_SHOW_PRICE");
        public final static Property KtFont = new Property(43, Long.class, "ktFont", false, "KT_FONT");
        public final static Property Conditions = new Property(44, Long.class, "conditions", false, "CONDITIONS");
        public final static Property IsRt = new Property(45, Long.class, "isRt", false, "IS_RT");
        public final static Property Visible = new Property(46, Byte.class, "visible", false, "VISIBLE");
        public final static Property Deletes = new Property(47, Long.class, "deletes", false, "DELETES");
        public final static Property IsStatistic = new Property(48, Long.class, "isStatistic", false, "IS_STATISTIC");
    }

    private Query<Modifier> foodModifier_ModifiersQuery;

    public ModifierDao(DaoConfig config) {
        super(config);
    }
    
    public ModifierDao(DaoConfig config, DaoSession daoSession) {
        super(config, daoSession);
    }

    /** Creates the underlying database table. */
    public static void createTable(Database db, boolean ifNotExists) {
        String constraint = ifNotExists? "IF NOT EXISTS ": "";
        db.execSQL("CREATE TABLE " + constraint + "\"MODIFIER\" (" + //
                "\"_id\" INTEGER PRIMARY KEY AUTOINCREMENT ," + // 0: dbid
                "\"MID\" INTEGER," + // 1: mid
                "\"TOP_ID\" INTEGER," + // 2: topId
                "\"RESTAURANT_ID\" INTEGER," + // 3: restaurantId
                "\"MODIFIER_NAME\" TEXT," + // 4: modifierName
                "\"SEQ_NO\" INTEGER," + // 5: seqNo
                "\"MARKET_PRICE\" REAL," + // 6: marketPrice
                "\"PRICE\" REAL," + // 7: price
                "\"LUNCHBOX_PRICE\" REAL," + // 8: lunchboxPrice
                "\"COLOR_ID\" INTEGER," + // 9: colorId
                "\"IMAGE_URL\" TEXT," + // 10: imageUrl
                "\"INVISIBLE\" INTEGER," + // 11: invisible
                "\"COST\" REAL," + // 12: cost
                "\"START_DATE\" INTEGER," + // 13: startDate
                "\"END_DATE\" INTEGER," + // 14: endDate
                "\"LIKE\" INTEGER," + // 15: like
                "\"TOTAL_SOLD\" INTEGER," + // 16: totalSold
                "\"MAJOR_MAIN_ID\" INTEGER," + // 17: majorMainId
                "\"DEPT_ID\" INTEGER," + // 18: deptId
                "\"CREATE_BY\" TEXT," + // 19: createBy
                "\"CREATE_TIME\" INTEGER," + // 20: createTime
                "\"UPDATE_BY\" TEXT," + // 21: updateBy
                "\"UPDATE_TIME\" INTEGER," + // 22: updateTime
                "\"POS_FID\" TEXT," + // 23: posFid
                "\"P_ID\" TEXT," + // 24: pId
                "\"AUTO_MOD\" INTEGER," + // 25: autoMod
                "\"BLUE_EDIT\" INTEGER," + // 26: blueEdit
                "\"AUTO_MERGE\" INTEGER," + // 27: autoMerge
                "\"CUSTOM_MSG\" INTEGER," + // 28: customMsg
                "\"IS_PARENT\" INTEGER," + // 29: isParent
                "\"MODIFIER_NAME1\" TEXT," + // 30: modifierName1
                "\"MODIFIER_NAME2\" TEXT," + // 31: modifierName2
                "\"MULTIPLE\" REAL," + // 32: multiple
                "\"PRINT_SET\" TEXT," + // 33: printSet
                "\"KT_SETTING\" TEXT," + // 34: ktSetting
                "\"MOD_COMM\" INTEGER," + // 35: modComm
                "\"MOD_TASTE\" INTEGER," + // 36: modTaste
                "\"MOD_MSG\" INTEGER," + // 37: modMsg
                "\"KT_FIRE_COURSE\" INTEGER," + // 38: ktFireCourse
                "\"ABLE_DIS_COUNT\" INTEGER," + // 39: ableDisCount
                "\"PRINT_TO_BILL\" INTEGER," + // 40: printToBill
                "\"KT_PRINT_MAIN_ITEM\" INTEGER," + // 41: ktPrintMainItem
                "\"KT_SHOW_PRICE\" INTEGER," + // 42: ktShowPrice
                "\"KT_FONT\" INTEGER," + // 43: ktFont
                "\"CONDITIONS\" INTEGER," + // 44: conditions
                "\"IS_RT\" INTEGER," + // 45: isRt
                "\"VISIBLE\" INTEGER," + // 46: visible
                "\"DELETES\" INTEGER," + // 47: deletes
                "\"IS_STATISTIC\" INTEGER);"); // 48: isStatistic
    }

    /** Drops the underlying database table. */
    public static void dropTable(Database db, boolean ifExists) {
        String sql = "DROP TABLE " + (ifExists ? "IF EXISTS " : "") + "\"MODIFIER\"";
        db.execSQL(sql);
    }

    @Override
    protected final void bindValues(DatabaseStatement stmt, Modifier entity) {
        stmt.clearBindings();
 
        Long dbid = entity.getDbid();
        if (dbid != null) {
            stmt.bindLong(1, dbid);
        }
 
        Long mid = entity.getMid();
        if (mid != null) {
            stmt.bindLong(2, mid);
        }
 
        Long topId = entity.getTopId();
        if (topId != null) {
            stmt.bindLong(3, topId);
        }
 
        Long restaurantId = entity.getRestaurantId();
        if (restaurantId != null) {
            stmt.bindLong(4, restaurantId);
        }
 
        String modifierName = entity.getModifierName();
        if (modifierName != null) {
            stmt.bindString(5, modifierName);
        }
 
        Long seqNo = entity.getSeqNo();
        if (seqNo != null) {
            stmt.bindLong(6, seqNo);
        }
 
        Double marketPrice = entity.getMarketPrice();
        if (marketPrice != null) {
            stmt.bindDouble(7, marketPrice);
        }
 
        Double price = entity.getPrice();
        if (price != null) {
            stmt.bindDouble(8, price);
        }
 
        Double lunchboxPrice = entity.getLunchboxPrice();
        if (lunchboxPrice != null) {
            stmt.bindDouble(9, lunchboxPrice);
        }
 
        Long colorId = entity.getColorId();
        if (colorId != null) {
            stmt.bindLong(10, colorId);
        }
 
        String imageUrl = entity.getImageUrl();
        if (imageUrl != null) {
            stmt.bindString(11, imageUrl);
        }
 
        Long invisible = entity.getInvisible();
        if (invisible != null) {
            stmt.bindLong(12, invisible);
        }
 
        Double cost = entity.getCost();
        if (cost != null) {
            stmt.bindDouble(13, cost);
        }
 
        java.util.Date startDate = entity.getStartDate();
        if (startDate != null) {
            stmt.bindLong(14, startDate.getTime());
        }
 
        java.util.Date endDate = entity.getEndDate();
        if (endDate != null) {
            stmt.bindLong(15, endDate.getTime());
        }
 
        Long like = entity.getLike();
        if (like != null) {
            stmt.bindLong(16, like);
        }
 
        Long totalSold = entity.getTotalSold();
        if (totalSold != null) {
            stmt.bindLong(17, totalSold);
        }
 
        Long majorMainId = entity.getMajorMainId();
        if (majorMainId != null) {
            stmt.bindLong(18, majorMainId);
        }
 
        Long deptId = entity.getDeptId();
        if (deptId != null) {
            stmt.bindLong(19, deptId);
        }
 
        String createBy = entity.getCreateBy();
        if (createBy != null) {
            stmt.bindString(20, createBy);
        }
 
        java.util.Date createTime = entity.getCreateTime();
        if (createTime != null) {
            stmt.bindLong(21, createTime.getTime());
        }
 
        String updateBy = entity.getUpdateBy();
        if (updateBy != null) {
            stmt.bindString(22, updateBy);
        }
 
        java.util.Date updateTime = entity.getUpdateTime();
        if (updateTime != null) {
            stmt.bindLong(23, updateTime.getTime());
        }
 
        String posFid = entity.getPosFid();
        if (posFid != null) {
            stmt.bindString(24, posFid);
        }
 
        String pId = entity.getPId();
        if (pId != null) {
            stmt.bindString(25, pId);
        }
 
        Long autoMod = entity.getAutoMod();
        if (autoMod != null) {
            stmt.bindLong(26, autoMod);
        }
 
        Long blueEdit = entity.getBlueEdit();
        if (blueEdit != null) {
            stmt.bindLong(27, blueEdit);
        }
 
        Long autoMerge = entity.getAutoMerge();
        if (autoMerge != null) {
            stmt.bindLong(28, autoMerge);
        }
 
        Long customMsg = entity.getCustomMsg();
        if (customMsg != null) {
            stmt.bindLong(29, customMsg);
        }
 
        Long isParent = entity.getIsParent();
        if (isParent != null) {
            stmt.bindLong(30, isParent);
        }
 
        String modifierName1 = entity.getModifierName1();
        if (modifierName1 != null) {
            stmt.bindString(31, modifierName1);
        }
 
        String modifierName2 = entity.getModifierName2();
        if (modifierName2 != null) {
            stmt.bindString(32, modifierName2);
        }
 
        Double multiple = entity.getMultiple();
        if (multiple != null) {
            stmt.bindDouble(33, multiple);
        }
 
        String printSet = entity.getPrintSet();
        if (printSet != null) {
            stmt.bindString(34, printSet);
        }
 
        String ktSetting = entity.getKtSetting();
        if (ktSetting != null) {
            stmt.bindString(35, ktSetting);
        }
 
        Long modComm = entity.getModComm();
        if (modComm != null) {
            stmt.bindLong(36, modComm);
        }
 
        Long modTaste = entity.getModTaste();
        if (modTaste != null) {
            stmt.bindLong(37, modTaste);
        }
 
        Long modMsg = entity.getModMsg();
        if (modMsg != null) {
            stmt.bindLong(38, modMsg);
        }
 
        Long ktFireCourse = entity.getKtFireCourse();
        if (ktFireCourse != null) {
            stmt.bindLong(39, ktFireCourse);
        }
 
        Long ableDisCount = entity.getAbleDisCount();
        if (ableDisCount != null) {
            stmt.bindLong(40, ableDisCount);
        }
 
        Long printToBill = entity.getPrintToBill();
        if (printToBill != null) {
            stmt.bindLong(41, printToBill);
        }
 
        Long ktPrintMainItem = entity.getKtPrintMainItem();
        if (ktPrintMainItem != null) {
            stmt.bindLong(42, ktPrintMainItem);
        }
 
        Long ktShowPrice = entity.getKtShowPrice();
        if (ktShowPrice != null) {
            stmt.bindLong(43, ktShowPrice);
        }
 
        Long ktFont = entity.getKtFont();
        if (ktFont != null) {
            stmt.bindLong(44, ktFont);
        }
 
        Long conditions = entity.getConditions();
        if (conditions != null) {
            stmt.bindLong(45, conditions);
        }
 
        Long isRt = entity.getIsRt();
        if (isRt != null) {
            stmt.bindLong(46, isRt);
        }
 
        Byte visible = entity.getVisible();
        if (visible != null) {
            stmt.bindLong(47, visible);
        }
 
        Long deletes = entity.getDeletes();
        if (deletes != null) {
            stmt.bindLong(48, deletes);
        }
 
        Long isStatistic = entity.getIsStatistic();
        if (isStatistic != null) {
            stmt.bindLong(49, isStatistic);
        }
    }

    @Override
    protected final void bindValues(SQLiteStatement stmt, Modifier entity) {
        stmt.clearBindings();
 
        Long dbid = entity.getDbid();
        if (dbid != null) {
            stmt.bindLong(1, dbid);
        }
 
        Long mid = entity.getMid();
        if (mid != null) {
            stmt.bindLong(2, mid);
        }
 
        Long topId = entity.getTopId();
        if (topId != null) {
            stmt.bindLong(3, topId);
        }
 
        Long restaurantId = entity.getRestaurantId();
        if (restaurantId != null) {
            stmt.bindLong(4, restaurantId);
        }
 
        String modifierName = entity.getModifierName();
        if (modifierName != null) {
            stmt.bindString(5, modifierName);
        }
 
        Long seqNo = entity.getSeqNo();
        if (seqNo != null) {
            stmt.bindLong(6, seqNo);
        }
 
        Double marketPrice = entity.getMarketPrice();
        if (marketPrice != null) {
            stmt.bindDouble(7, marketPrice);
        }
 
        Double price = entity.getPrice();
        if (price != null) {
            stmt.bindDouble(8, price);
        }
 
        Double lunchboxPrice = entity.getLunchboxPrice();
        if (lunchboxPrice != null) {
            stmt.bindDouble(9, lunchboxPrice);
        }
 
        Long colorId = entity.getColorId();
        if (colorId != null) {
            stmt.bindLong(10, colorId);
        }
 
        String imageUrl = entity.getImageUrl();
        if (imageUrl != null) {
            stmt.bindString(11, imageUrl);
        }
 
        Long invisible = entity.getInvisible();
        if (invisible != null) {
            stmt.bindLong(12, invisible);
        }
 
        Double cost = entity.getCost();
        if (cost != null) {
            stmt.bindDouble(13, cost);
        }
 
        java.util.Date startDate = entity.getStartDate();
        if (startDate != null) {
            stmt.bindLong(14, startDate.getTime());
        }
 
        java.util.Date endDate = entity.getEndDate();
        if (endDate != null) {
            stmt.bindLong(15, endDate.getTime());
        }
 
        Long like = entity.getLike();
        if (like != null) {
            stmt.bindLong(16, like);
        }
 
        Long totalSold = entity.getTotalSold();
        if (totalSold != null) {
            stmt.bindLong(17, totalSold);
        }
 
        Long majorMainId = entity.getMajorMainId();
        if (majorMainId != null) {
            stmt.bindLong(18, majorMainId);
        }
 
        Long deptId = entity.getDeptId();
        if (deptId != null) {
            stmt.bindLong(19, deptId);
        }
 
        String createBy = entity.getCreateBy();
        if (createBy != null) {
            stmt.bindString(20, createBy);
        }
 
        java.util.Date createTime = entity.getCreateTime();
        if (createTime != null) {
            stmt.bindLong(21, createTime.getTime());
        }
 
        String updateBy = entity.getUpdateBy();
        if (updateBy != null) {
            stmt.bindString(22, updateBy);
        }
 
        java.util.Date updateTime = entity.getUpdateTime();
        if (updateTime != null) {
            stmt.bindLong(23, updateTime.getTime());
        }
 
        String posFid = entity.getPosFid();
        if (posFid != null) {
            stmt.bindString(24, posFid);
        }
 
        String pId = entity.getPId();
        if (pId != null) {
            stmt.bindString(25, pId);
        }
 
        Long autoMod = entity.getAutoMod();
        if (autoMod != null) {
            stmt.bindLong(26, autoMod);
        }
 
        Long blueEdit = entity.getBlueEdit();
        if (blueEdit != null) {
            stmt.bindLong(27, blueEdit);
        }
 
        Long autoMerge = entity.getAutoMerge();
        if (autoMerge != null) {
            stmt.bindLong(28, autoMerge);
        }
 
        Long customMsg = entity.getCustomMsg();
        if (customMsg != null) {
            stmt.bindLong(29, customMsg);
        }
 
        Long isParent = entity.getIsParent();
        if (isParent != null) {
            stmt.bindLong(30, isParent);
        }
 
        String modifierName1 = entity.getModifierName1();
        if (modifierName1 != null) {
            stmt.bindString(31, modifierName1);
        }
 
        String modifierName2 = entity.getModifierName2();
        if (modifierName2 != null) {
            stmt.bindString(32, modifierName2);
        }
 
        Double multiple = entity.getMultiple();
        if (multiple != null) {
            stmt.bindDouble(33, multiple);
        }
 
        String printSet = entity.getPrintSet();
        if (printSet != null) {
            stmt.bindString(34, printSet);
        }
 
        String ktSetting = entity.getKtSetting();
        if (ktSetting != null) {
            stmt.bindString(35, ktSetting);
        }
 
        Long modComm = entity.getModComm();
        if (modComm != null) {
            stmt.bindLong(36, modComm);
        }
 
        Long modTaste = entity.getModTaste();
        if (modTaste != null) {
            stmt.bindLong(37, modTaste);
        }
 
        Long modMsg = entity.getModMsg();
        if (modMsg != null) {
            stmt.bindLong(38, modMsg);
        }
 
        Long ktFireCourse = entity.getKtFireCourse();
        if (ktFireCourse != null) {
            stmt.bindLong(39, ktFireCourse);
        }
 
        Long ableDisCount = entity.getAbleDisCount();
        if (ableDisCount != null) {
            stmt.bindLong(40, ableDisCount);
        }
 
        Long printToBill = entity.getPrintToBill();
        if (printToBill != null) {
            stmt.bindLong(41, printToBill);
        }
 
        Long ktPrintMainItem = entity.getKtPrintMainItem();
        if (ktPrintMainItem != null) {
            stmt.bindLong(42, ktPrintMainItem);
        }
 
        Long ktShowPrice = entity.getKtShowPrice();
        if (ktShowPrice != null) {
            stmt.bindLong(43, ktShowPrice);
        }
 
        Long ktFont = entity.getKtFont();
        if (ktFont != null) {
            stmt.bindLong(44, ktFont);
        }
 
        Long conditions = entity.getConditions();
        if (conditions != null) {
            stmt.bindLong(45, conditions);
        }
 
        Long isRt = entity.getIsRt();
        if (isRt != null) {
            stmt.bindLong(46, isRt);
        }
 
        Byte visible = entity.getVisible();
        if (visible != null) {
            stmt.bindLong(47, visible);
        }
 
        Long deletes = entity.getDeletes();
        if (deletes != null) {
            stmt.bindLong(48, deletes);
        }
 
        Long isStatistic = entity.getIsStatistic();
        if (isStatistic != null) {
            stmt.bindLong(49, isStatistic);
        }
    }

    @Override
    public Long readKey(Cursor cursor, int offset) {
        return cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0);
    }    

    @Override
    public Modifier readEntity(Cursor cursor, int offset) {
        Modifier entity = new Modifier( //
            cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0), // dbid
            cursor.isNull(offset + 1) ? null : cursor.getLong(offset + 1), // mid
            cursor.isNull(offset + 2) ? null : cursor.getLong(offset + 2), // topId
            cursor.isNull(offset + 3) ? null : cursor.getLong(offset + 3), // restaurantId
            cursor.isNull(offset + 4) ? null : cursor.getString(offset + 4), // modifierName
            cursor.isNull(offset + 5) ? null : cursor.getLong(offset + 5), // seqNo
            cursor.isNull(offset + 6) ? null : cursor.getDouble(offset + 6), // marketPrice
            cursor.isNull(offset + 7) ? null : cursor.getDouble(offset + 7), // price
            cursor.isNull(offset + 8) ? null : cursor.getDouble(offset + 8), // lunchboxPrice
            cursor.isNull(offset + 9) ? null : cursor.getLong(offset + 9), // colorId
            cursor.isNull(offset + 10) ? null : cursor.getString(offset + 10), // imageUrl
            cursor.isNull(offset + 11) ? null : cursor.getLong(offset + 11), // invisible
            cursor.isNull(offset + 12) ? null : cursor.getDouble(offset + 12), // cost
            cursor.isNull(offset + 13) ? null : new java.util.Date(cursor.getLong(offset + 13)), // startDate
            cursor.isNull(offset + 14) ? null : new java.util.Date(cursor.getLong(offset + 14)), // endDate
            cursor.isNull(offset + 15) ? null : cursor.getLong(offset + 15), // like
            cursor.isNull(offset + 16) ? null : cursor.getLong(offset + 16), // totalSold
            cursor.isNull(offset + 17) ? null : cursor.getLong(offset + 17), // majorMainId
            cursor.isNull(offset + 18) ? null : cursor.getLong(offset + 18), // deptId
            cursor.isNull(offset + 19) ? null : cursor.getString(offset + 19), // createBy
            cursor.isNull(offset + 20) ? null : new java.util.Date(cursor.getLong(offset + 20)), // createTime
            cursor.isNull(offset + 21) ? null : cursor.getString(offset + 21), // updateBy
            cursor.isNull(offset + 22) ? null : new java.util.Date(cursor.getLong(offset + 22)), // updateTime
            cursor.isNull(offset + 23) ? null : cursor.getString(offset + 23), // posFid
            cursor.isNull(offset + 24) ? null : cursor.getString(offset + 24), // pId
            cursor.isNull(offset + 25) ? null : cursor.getLong(offset + 25), // autoMod
            cursor.isNull(offset + 26) ? null : cursor.getLong(offset + 26), // blueEdit
            cursor.isNull(offset + 27) ? null : cursor.getLong(offset + 27), // autoMerge
            cursor.isNull(offset + 28) ? null : cursor.getLong(offset + 28), // customMsg
            cursor.isNull(offset + 29) ? null : cursor.getLong(offset + 29), // isParent
            cursor.isNull(offset + 30) ? null : cursor.getString(offset + 30), // modifierName1
            cursor.isNull(offset + 31) ? null : cursor.getString(offset + 31), // modifierName2
            cursor.isNull(offset + 32) ? null : cursor.getDouble(offset + 32), // multiple
            cursor.isNull(offset + 33) ? null : cursor.getString(offset + 33), // printSet
            cursor.isNull(offset + 34) ? null : cursor.getString(offset + 34), // ktSetting
            cursor.isNull(offset + 35) ? null : cursor.getLong(offset + 35), // modComm
            cursor.isNull(offset + 36) ? null : cursor.getLong(offset + 36), // modTaste
            cursor.isNull(offset + 37) ? null : cursor.getLong(offset + 37), // modMsg
            cursor.isNull(offset + 38) ? null : cursor.getLong(offset + 38), // ktFireCourse
            cursor.isNull(offset + 39) ? null : cursor.getLong(offset + 39), // ableDisCount
            cursor.isNull(offset + 40) ? null : cursor.getLong(offset + 40), // printToBill
            cursor.isNull(offset + 41) ? null : cursor.getLong(offset + 41), // ktPrintMainItem
            cursor.isNull(offset + 42) ? null : cursor.getLong(offset + 42), // ktShowPrice
            cursor.isNull(offset + 43) ? null : cursor.getLong(offset + 43), // ktFont
            cursor.isNull(offset + 44) ? null : cursor.getLong(offset + 44), // conditions
            cursor.isNull(offset + 45) ? null : cursor.getLong(offset + 45), // isRt
            cursor.isNull(offset + 46) ? null : (byte) cursor.getShort(offset + 46), // visible
            cursor.isNull(offset + 47) ? null : cursor.getLong(offset + 47), // deletes
            cursor.isNull(offset + 48) ? null : cursor.getLong(offset + 48) // isStatistic
        );
        return entity;
    }
     
    @Override
    public void readEntity(Cursor cursor, Modifier entity, int offset) {
        entity.setDbid(cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0));
        entity.setMid(cursor.isNull(offset + 1) ? null : cursor.getLong(offset + 1));
        entity.setTopId(cursor.isNull(offset + 2) ? null : cursor.getLong(offset + 2));
        entity.setRestaurantId(cursor.isNull(offset + 3) ? null : cursor.getLong(offset + 3));
        entity.setModifierName(cursor.isNull(offset + 4) ? null : cursor.getString(offset + 4));
        entity.setSeqNo(cursor.isNull(offset + 5) ? null : cursor.getLong(offset + 5));
        entity.setMarketPrice(cursor.isNull(offset + 6) ? null : cursor.getDouble(offset + 6));
        entity.setPrice(cursor.isNull(offset + 7) ? null : cursor.getDouble(offset + 7));
        entity.setLunchboxPrice(cursor.isNull(offset + 8) ? null : cursor.getDouble(offset + 8));
        entity.setColorId(cursor.isNull(offset + 9) ? null : cursor.getLong(offset + 9));
        entity.setImageUrl(cursor.isNull(offset + 10) ? null : cursor.getString(offset + 10));
        entity.setInvisible(cursor.isNull(offset + 11) ? null : cursor.getLong(offset + 11));
        entity.setCost(cursor.isNull(offset + 12) ? null : cursor.getDouble(offset + 12));
        entity.setStartDate(cursor.isNull(offset + 13) ? null : new java.util.Date(cursor.getLong(offset + 13)));
        entity.setEndDate(cursor.isNull(offset + 14) ? null : new java.util.Date(cursor.getLong(offset + 14)));
        entity.setLike(cursor.isNull(offset + 15) ? null : cursor.getLong(offset + 15));
        entity.setTotalSold(cursor.isNull(offset + 16) ? null : cursor.getLong(offset + 16));
        entity.setMajorMainId(cursor.isNull(offset + 17) ? null : cursor.getLong(offset + 17));
        entity.setDeptId(cursor.isNull(offset + 18) ? null : cursor.getLong(offset + 18));
        entity.setCreateBy(cursor.isNull(offset + 19) ? null : cursor.getString(offset + 19));
        entity.setCreateTime(cursor.isNull(offset + 20) ? null : new java.util.Date(cursor.getLong(offset + 20)));
        entity.setUpdateBy(cursor.isNull(offset + 21) ? null : cursor.getString(offset + 21));
        entity.setUpdateTime(cursor.isNull(offset + 22) ? null : new java.util.Date(cursor.getLong(offset + 22)));
        entity.setPosFid(cursor.isNull(offset + 23) ? null : cursor.getString(offset + 23));
        entity.setPId(cursor.isNull(offset + 24) ? null : cursor.getString(offset + 24));
        entity.setAutoMod(cursor.isNull(offset + 25) ? null : cursor.getLong(offset + 25));
        entity.setBlueEdit(cursor.isNull(offset + 26) ? null : cursor.getLong(offset + 26));
        entity.setAutoMerge(cursor.isNull(offset + 27) ? null : cursor.getLong(offset + 27));
        entity.setCustomMsg(cursor.isNull(offset + 28) ? null : cursor.getLong(offset + 28));
        entity.setIsParent(cursor.isNull(offset + 29) ? null : cursor.getLong(offset + 29));
        entity.setModifierName1(cursor.isNull(offset + 30) ? null : cursor.getString(offset + 30));
        entity.setModifierName2(cursor.isNull(offset + 31) ? null : cursor.getString(offset + 31));
        entity.setMultiple(cursor.isNull(offset + 32) ? null : cursor.getDouble(offset + 32));
        entity.setPrintSet(cursor.isNull(offset + 33) ? null : cursor.getString(offset + 33));
        entity.setKtSetting(cursor.isNull(offset + 34) ? null : cursor.getString(offset + 34));
        entity.setModComm(cursor.isNull(offset + 35) ? null : cursor.getLong(offset + 35));
        entity.setModTaste(cursor.isNull(offset + 36) ? null : cursor.getLong(offset + 36));
        entity.setModMsg(cursor.isNull(offset + 37) ? null : cursor.getLong(offset + 37));
        entity.setKtFireCourse(cursor.isNull(offset + 38) ? null : cursor.getLong(offset + 38));
        entity.setAbleDisCount(cursor.isNull(offset + 39) ? null : cursor.getLong(offset + 39));
        entity.setPrintToBill(cursor.isNull(offset + 40) ? null : cursor.getLong(offset + 40));
        entity.setKtPrintMainItem(cursor.isNull(offset + 41) ? null : cursor.getLong(offset + 41));
        entity.setKtShowPrice(cursor.isNull(offset + 42) ? null : cursor.getLong(offset + 42));
        entity.setKtFont(cursor.isNull(offset + 43) ? null : cursor.getLong(offset + 43));
        entity.setConditions(cursor.isNull(offset + 44) ? null : cursor.getLong(offset + 44));
        entity.setIsRt(cursor.isNull(offset + 45) ? null : cursor.getLong(offset + 45));
        entity.setVisible(cursor.isNull(offset + 46) ? null : (byte) cursor.getShort(offset + 46));
        entity.setDeletes(cursor.isNull(offset + 47) ? null : cursor.getLong(offset + 47));
        entity.setIsStatistic(cursor.isNull(offset + 48) ? null : cursor.getLong(offset + 48));
     }
    
    @Override
    protected final Long updateKeyAfterInsert(Modifier entity, long rowId) {
        entity.setDbid(rowId);
        return rowId;
    }
    
    @Override
    public Long getKey(Modifier entity) {
        if(entity != null) {
            return entity.getDbid();
        } else {
            return null;
        }
    }

    @Override
    public boolean hasKey(Modifier entity) {
        return entity.getDbid() != null;
    }

    @Override
    protected final boolean isEntityUpdateable() {
        return true;
    }
    
    /** Internal query to resolve the "modifiers" to-many relationship of FoodModifier. */
    public List<Modifier> _queryFoodModifier_Modifiers(Long mid) {
        synchronized (this) {
            if (foodModifier_ModifiersQuery == null) {
                QueryBuilder<Modifier> queryBuilder = queryBuilder();
                queryBuilder.where(Properties.Mid.eq(null));
                foodModifier_ModifiersQuery = queryBuilder.build();
            }
        }
        Query<Modifier> query = foodModifier_ModifiersQuery.forCurrentThread();
        query.setParameter(0, mid);
        return query.list();
    }

}
