package com.gingersoft.gsa.cloud.base.utils.time;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * @ClassName: TimeUtils
 * @Description: TODO(时间工具类)
 */
public class TimeUtils {
    public static final SimpleDateFormat DEFAULT_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");//, Locale.CHINESE
    public static final SimpleDateFormat DATE_FORMAT_DATE = new SimpleDateFormat("yyyy-MM-dd");
    public static final SimpleDateFormat DATE_FORMAT_DATE1 = new SimpleDateFormat(
            "HH:mm");

    private TimeUtils() {
        throw new AssertionError();
    }


    public static String getYesterdayTime(SimpleDateFormat simpleDateFormat) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(Calendar.DAY_OF_MONTH, -1);//往上推一天
        return simpleDateFormat.format(calendar.getTime());
    }

    /**
     * long time to string
     *
     * @param timeInMillis
     * @param dateFormat
     * @return
     */
    public static String getTime(long timeInMillis, SimpleDateFormat dateFormat) {
        return dateFormat.format(new Date(timeInMillis));
    }

    /**
     * long time to string, format is {@link #DEFAULT_DATE_FORMAT}
     *
     * @param timeInMillis
     * @return
     */
    public static String getCurrentTime(long timeInMillis) {
        return getTime(timeInMillis, DEFAULT_DATE_FORMAT);
    }

    /**
     * get current time in milliseconds
     *
     * @return
     */
    public static long getCurrentTimeInLong() {
        return System.currentTimeMillis();
    }

    /**
     * get current time in milliseconds
     *
     * @return
     */
    public static String getCurrentTimeInString(SimpleDateFormat dateFormat) {
        return getTime(getCurrentTimeInLong(), dateFormat);
    }

    /**
     * 把日期型字符串转换为数字型字符串
     *
     * @param time
     * @return
     */
    public static String tranTime(String time) {
        if (time != null) {
            String year;
            String month;
            String day;
            String hour;
            String minute;
            String second;
            year = time.substring(0, 4);
            month = time.substring(5, 7);
            day = time.substring(8, 10);
            hour = time.substring(11, 13);
            minute = time.substring(14, 16);
            second = time.substring(17, 19);
            String newTime = String.format("%s%s%s%s%s%s", year, month, day,
                    hour, minute, second);
            return newTime;
        } else
            return time;
    }

    /**
     * 字符串转换成日期
     *
     * @param str
     * @return date
     */
    public static Date StrToDate(String str) {

        Date date = null;
        try {
            date = DEFAULT_DATE_FORMAT.parse(str);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    /**
     * 把日期转为字符串
     *
     * @param date
     * @return
     * @Title: ConverToString
     * @Description: TODO(这里用一句话描述这个方法的作用)
     */
    public static String ConverToString(Date date) {
        return DATE_FORMAT_DATE1.format(date);
    }

    /**
     * 日期转换成秒数
     */
    public static long getSecondsFromDate(String expireDate) {
        if (expireDate == null || expireDate.trim().equals(""))
            return 0;
        Date date = null;
        try {
            date = DEFAULT_DATE_FORMAT.parse(expireDate);
            return (long) (date.getTime() / 1000);
        } catch (ParseException e) {
            e.printStackTrace();
            return 0L;
        }
    }
//
//    /**
//     * 时间戳格式转换
//     */
//    static String dayNames[] = {app.getString(R.string.sunday), app.getString(R.string.monday),
//            app.getString(R.string.tuesday), app.getString(R.string.wednesday), app.getString(R.string.thursday),
//            app.getString(R.string.friday), app.getString(R.string.saturday)};
//
//    public static String getNewChatTime(long timesamp) {
//        String result = "";
//        Calendar todayCalendar = Calendar.getInstance();
//        Calendar otherCalendar = Calendar.getInstance();
//        otherCalendar.setTimeInMillis(timesamp);
//        String timeFormat = "M" + app.getString(R.string.month) + "d" + app.getString(R.string.day) + " " + "HH:mm";
//        String yearTimeFormat = "yyyy" + app.getString(R.string.year) + "M" + app.getString(R.string.month) + "d" + app.getString(R.string.day) + " " + "HH:mm";
//        String am_pm = "";
//        int hour = otherCalendar.get(Calendar.HOUR_OF_DAY);
//        if (hour >= 0 && hour < 6) {
//            am_pm = app.getString(R.string.early_morning);
//        } else if (hour >= 6 && hour < 12) {
//            am_pm = app.getString(R.string.morning);
//        } else if (hour == 12) {
//            am_pm = app.getString(R.string.noon);
//        } else if (hour > 12 && hour < 18) {
//            am_pm = app.getString(R.string.afternoon);
//        } else if (hour >= 18) {
//            am_pm = app.getString(R.string.at_night);
//        }
//        timeFormat = "M" + app.getString(R.string.month) + "d" + app.getString(R.string.day) + " " + am_pm + "HH:mm";
//        yearTimeFormat = "yyyy" + app.getString(R.string.year) + "M" + app.getString(R.string.month) + "d" + app.getString(R.string.day) + " " + am_pm + "HH:mm";
//
//        boolean yearTemp = todayCalendar.get(Calendar.YEAR) == otherCalendar.get(Calendar.YEAR);
//        if (yearTemp) {
//            int todayMonth = todayCalendar.get(Calendar.MONTH);
//            int otherMonth = otherCalendar.get(Calendar.MONTH);
//            if (todayMonth == otherMonth) {//表示是同一个月
//                int temp = todayCalendar.get(Calendar.DATE) - otherCalendar.get(Calendar.DATE);
//                switch (temp) {
//                    case 0:
//                        result = am_pm + " " + getHourAndMin(timesamp);
//                        break;
//                    case 1:
//                        result = app.getString(R.string.yesterday) + " " + am_pm + " " + getHourAndMin(timesamp);
//                        break;
//                    case 2:
//                    case 3:
//                    case 4:
//                    case 5:
//                    case 6:
//                        int dayOfMonth = otherCalendar.get(Calendar.WEEK_OF_MONTH);
//                        int todayOfMonth = todayCalendar.get(Calendar.WEEK_OF_MONTH);
//                        if (dayOfMonth == todayOfMonth) {//表示是同一周
////							int dayOfWeek=otherCalendar.get(Calendar.DAY_OF_WEEK);
////							if(dayOfWeek!=1){//判断当前是不是星期日     如想显示为：周日 12:09 可去掉此判断
//                            result = dayNames[otherCalendar.get(Calendar.DAY_OF_WEEK) - 1] + " " + am_pm + " " + getHourAndMin(timesamp);
////							}else{
////								result = getTime(timesamp,timeFormat);
////							}
//                        } else {
//                            result = getTime(timesamp, timeFormat);
//                        }
//                        break;
//                    default:
//                        result = getTime(timesamp, timeFormat);
//                        break;
//                }
//            } else {
//                result = getTime(timesamp, timeFormat);
//            }
//        } else {
//            result = getYearTime(timesamp, yearTimeFormat);
//        }
//        return result;
//    }

    /**
     * 当天的显示时间格式
     *
     * @param time
     * @return
     */
    public static String getHourAndMin(long time) {
        SimpleDateFormat format = new SimpleDateFormat("HH:mm");
        return format.format(new Date(time));
    }

    /**
     * 不同一周的显示时间格式
     *
     * @param time
     * @param timeFormat
     * @return
     */
    public static String getTime(long time, String timeFormat) {
        SimpleDateFormat format = new SimpleDateFormat(timeFormat);
        return format.format(new Date(time));
    }

    /**
     * 不同年的显示时间格式
     *
     * @param time
     * @param yearTimeFormat
     * @return
     */
    public static String getYearTime(long time, String yearTimeFormat) {
        SimpleDateFormat format = new SimpleDateFormat(yearTimeFormat);
        return format.format(new Date(time));
    }
}
