package com.gingersoft.gsa.cloud.table.mvp.model.service;

import com.gingersoft.gsa.cloud.base.bean.BaseRespose;
import com.gingersoft.gsa.cloud.table.mvp.model.bean.TableBean;

import io.reactivex.Observable;
import me.jessyan.retrofiturlmanager.RetrofitUrlManager;
import okhttp3.RequestBody;
import retrofit2.http.Body;
import retrofit2.http.Field;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.Query;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2019-12-28
 * 修订历史：2019-12-28
 * 描述：
 */
public interface TableService {


    @GET("restaurantTable/list" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<TableBean> getTables(@Query("restaurantId") int restaurantId);


    @POST("restaurantTable/kickOff" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseRespose> openTable(@Body RequestBody requestBody);

    @FormUrlEncoded
    @POST("restaurantTable/set/status" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<Object> initTable(@Body RequestBody requestBody);
}
