package com.gingersoft.gsa.cloud.table.mvp.ui.fragment;

import android.content.Intent;
import android.os.Bundle;
import android.os.Message;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;

import com.gingersoft.gsa.cloud.table.R;
import com.gingersoft.gsa.cloud.table.app.GoldConstants;
import com.gingersoft.gsa.cloud.table.di.component.DaggerAllTableComponent;
import com.gingersoft.gsa.cloud.table.mvp.model.bean.TableBean;
import com.gingersoft.gsa.cloud.table.mvp.ui.activity.TableActivity;
import com.jess.arms.base.BaseFragment;
import com.jess.arms.base.DefaultAdapter;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.utils.ArmsUtils;
import com.gingersoft.gsa.cloud.table.mvp.contract.AllTableContract;
import com.gingersoft.gsa.cloud.table.mvp.presenter.AllTablePresenter;
import com.gingersoft.gsa.cloud.table.R2;
import java.util.List;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import butterknife.BindView;

import static android.widget.AbsListView.OnScrollListener.SCROLL_STATE_IDLE;
import static androidx.recyclerview.widget.RecyclerView.SCROLL_STATE_DRAGGING;
import static androidx.recyclerview.widget.RecyclerView.SCROLL_STATE_SETTLING;
import static com.jess.arms.utils.Preconditions.checkNotNull;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 12/28/2019 17:33
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public class AllTableFragment extends BaseFragment<AllTablePresenter> implements AllTableContract.View {


    @BindView(R2.id.recycle_all_table)
    RecyclerView recycle_all_table;

    private TableActivity mActivity;

    private List<TableBean.DataBean> datasBeans;

    public static AllTableFragment newInstance() {
        AllTableFragment fragment = new AllTableFragment();
        return fragment;
    }

    @Override
    public void setupFragmentComponent(@NonNull AppComponent appComponent) {
        DaggerAllTableComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public View initView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.table_fragment_all_table, container, false);
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
        mActivity = (TableActivity) getActivity();

        initRecycleScrollListener();
    }

    private void initRecycleScrollListener() {
        recycle_all_table.addOnScrollListener(new RecyclerView.OnScrollListener() {

            @Override
            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                switch (newState) {
                    case SCROLL_STATE_IDLE://停止滚动
                        mActivity.onStartRefreshTableData();
                        break;
                    case SCROLL_STATE_DRAGGING://正在被外部拖拽,一般为用户正在用手指滚动
                    case SCROLL_STATE_SETTLING://自动滚动开始
                        mActivity.onPauseRefreshTableData();
                        break;
                }
            }
        });
        recycle_all_table.setOnTouchListener(new View.OnTouchListener() {

            @Override
            public boolean onTouch(View v, MotionEvent event) {
                int action =  event.getAction();
                switch (action){
                    case MotionEvent.ACTION_DOWN:
                    case MotionEvent.ACTION_MOVE: //用户滑动 先停止刷新餐台数据
                        mActivity.onPauseRefreshTableData();
                        break;
                    case MotionEvent.ACTION_UP:
                    case MotionEvent.ACTION_CANCEL:
                        mActivity.onStartRefreshTableData();//用户手抬起是 继续刷新餐台数据
                        break;
                }
                return false;
            }
        });
    }

    @Override
    public void setData(@Nullable Object data) {
        if (data != null && data instanceof Message) {
            switch (((Message) data).what) {
                case 0:
                    break;
                case 1://刷新全部数据
                    datasBeans = (List<TableBean.DataBean>) ((Message) data).obj;
                    if (mPresenter != null) {
                        //recycleView正在滑动
                        if (recycle_all_table.getScrollState() != 0) {
                        } else {
                            mPresenter.updateAllTableData(getActivity(), datasBeans);
                        }
                    }
                    break;
                case 2://刷新状态已变数据
                    datasBeans = (List<TableBean.DataBean>) ((Message) data).obj;
                    if (mPresenter != null) {
                        //recycleView正在滑动
                        if (recycle_all_table.getScrollState() != 0) {
                        } else {
                            mPresenter.updataTableItem(datasBeans);
                        }
                    }
                    break;
                default:
                    //do something
                    break;
            }
        }
    }


    @Override
    public void showLoading(String message) {

    }

    @Override
    public void hideLoading() {

    }

    @Override
    public void showMessage(@NonNull String message) {
        checkNotNull(message);
        ArmsUtils.snackbarText(message);
    }

    @Override
    public void launchActivity(@NonNull Intent intent) {
        checkNotNull(intent);
        ArmsUtils.startActivity(intent);
    }

    @Override
    public void killMyself() {

    }

    @Override
    public void setAllTableAdapter(DefaultAdapter adapter) {
        recycle_all_table.setAdapter(adapter);
        initAllTableRecycleViewLayout();
    }

    private GridLayoutManager mAllTableRecycleLayoutManager;

    private void initAllTableRecycleViewLayout() {
//        if (GSAApplication.androidSetting.getTableDirection() == 2) { //横向展示
//            mAllTableRecycleLayoutManager = new GridLayoutManager(getActivity(), 5, LinearLayoutManager.HORIZONTAL, false);
//            recycle_all_table.setLayoutManager(mAllTableRecycleLayoutManager);
//            recycle_all_table.setItemAnimator(new DefaultItemAnimator());
//            recycle_all_table.addItemDecoration(new DividerItemDecoration(getActivity(), LinearLayoutManager.VERTICAL));
//            recycle_all_table.addItemDecoration(new DividerItemDecoration(getActivity(), LinearLayoutManager.HORIZONTAL));
//        } else {
            mAllTableRecycleLayoutManager = new GridLayoutManager(getActivity(), 4, LinearLayoutManager.VERTICAL, false);
            recycle_all_table.setLayoutManager(mAllTableRecycleLayoutManager);
            recycle_all_table.setItemAnimator(new DefaultItemAnimator());
            recycle_all_table.addItemDecoration(new DividerItemDecoration(getActivity(), LinearLayoutManager.HORIZONTAL));
            recycle_all_table.addItemDecoration(new DividerItemDecoration(getActivity(), LinearLayoutManager.VERTICAL));
//        }
    }
}
