package com.gingersoft.gsa.cloud.meal.mvp.ui.adapter.meal;

import android.content.Context;
import android.text.TextUtils;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.gingersoft.gsa.cloud.base.bean.FoodBean;
import com.gingersoft.gsa.cloud.database.bean.Food;
import com.gingersoft.gsa.cloud.meal.R2;
import com.gingersoft.gsa.cloud.meal.mvp.model.manage.MyOrderManage;
import com.gingersoft.gsa.cloud.base.utils.MoneyUtil;
import com.gingersoft.gsa.cloud.meal.R;
import com.gingersoft.gsa.cloud.meal.mvp.model.bean.OrderDetail;
import com.gingersoft.gsa.cloud.meal.mvp.model.constant.MealConstant;
import com.gingersoft.gsa.cloud.meal.mvp.presenter.MealStandPresenter;
import com.gingersoft.gsa.cloud.meal.mvp.ui.activity.MealStandActivity;
import com.jess.arms.base.BaseHolder;
import com.jess.arms.base.DefaultAdapter;
import com.jess.arms.utils.ArmsUtils;
import com.jess.arms.utils.ThirdViewUtil;
import com.zhy.autolayout.utils.AutoUtils;

import java.util.ArrayList;
import java.util.List;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import butterknife.BindView;


/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2018/9/16
 * 修订历史：2018/9/17
 * 描述：
 */

public class SelectMealAdapter extends DefaultAdapter<Food> {

    private MealStandActivity mContext;
    private MealStandPresenter mPresenter;

    private int BillListFontSize = 18;
    private String carshStr = "$";

    private int mOrderNumberShowSize;
    private int mOrderNumberFontSize;
    private int mFoodFontSize;

    private int mColwidth;
    private int mColHeight;
    private int mLayoutQtyHeight;

    private int mainStartPos = 0;
    private int mainEndPos = 0;

    private int select_position = -1;
    private int select_start_position = 0;
    private int select_end_position = 0;
    public int select_full_start_position = 0;
    public int select_full_end_position = 0;

    private boolean isRemove = false;

    public SelectMealAdapter(Context context, List<Food> data, MealStandPresenter presenter) {
        super(data);
        this.mContext = (MealStandActivity) context;
        this.mPresenter = presenter;
//        this.mOrderNumberShowSize = GSAApplication.androidSetting.getOrderNumberChildShowSize();
//        this.mOrderNumberFontSize = GSAApplication.androidSetting.getOrderNumberChildFontSize();
//        this.mFoodFontSize = GSAApplication.androidSetting.getFoodFontSize();
//        this.mColwidth = (int) ((DeviceUtils.getScreenWidth(context) / GSAApplication.androidSetting.getFoodCol()) - 4);
//        this.mColHeight = GSAApplication.androidSetting.getFoodBtnHeight();
//        this.mLayoutQtyHeight = GSAApplication.androidSetting.getLayoutQtyHeight();
//
//        this.BillListFontSize = GSAApplication.androidSetting.getFoodlListFontSize();
//        this.carshStr = LanguageUtils.get_language_system(context, "order.cashstr", "$");
    }

    @Override
    public int getItemCount() {
        return mInfos.size();
    }

    @Override
    public SelectMealItemHolder getHolder(View v, int viewType) {
        return new SelectMealItemHolder(v);
    }

    @Override
    public int getLayoutId(int viewType) {
        return R.layout.meal_item_select_meal_stand;
    }

    class SelectMealItemHolder extends BaseHolder<Food> implements View.OnClickListener {

        @BindView(R2.id.rl_container)
        RelativeLayout rl_container;

        @BindView(R2.id.rl_select)
        RelativeLayout rl_select;
        @BindView(R2.id.ll_tvname)
        LinearLayout ll_tvname;

        @BindView(R2.id.tv_number)
        TextView tv_number;
        @BindView(R2.id.tv_food_table_mode)
        TextView tv_food_table_mode;
        @BindView(R2.id.tv_modify_before_number)
        TextView tv_modify_before_number;
        @BindView(R2.id.tv_name)
        TextView tv_name;
        @BindView(R2.id.tv_money)
        TextView tv_money;

        @BindView(R2.id.tv_D)
        TextView tv_D;
        @BindView(R2.id.tv_S)
        TextView tv_S;
        @BindView(R2.id.tv_D_1)
        TextView tv_D_1;
        @BindView(R2.id.tv_S_1)
        TextView tv_S_1;

        @BindView(R2.id.img_lock)
        ImageView iv_lock;
        @BindView(R2.id.tv_discount_money)
        TextView tv_discount_money;
        @BindView(R2.id.tv_mix)
        TextView tv_mix;

        public SelectMealItemHolder(View itemView) {
            super(itemView);
        }

        @Override
        public void onClick(View view) {
            if (mOnItemClickListener != null) {
                int position = this.getPosition();
                if (position < mInfos.size()) {
                    setSelectPosition(position);
                    //设置当前选中的食品或食品组
                    mOnItemClickListener.onItemClick(mInfos.get(position), position);
                }
            }
        }

        @Override
        public void setData(Food datasBean, int position) {

            setViewVisibility(datasBean);
            setDSMark(datasBean);
            if (datasBean.isVisible()) {
                rl_container.setVisibility(View.VISIBLE);
                setName(datasBean);
                setNumber(datasBean);
                setFoodMode(datasBean);
                setMoney(datasBean);
                setColor(datasBean);
                setTextSize();
            } else {
                rl_container.setVisibility(View.INVISIBLE);
            }
        }

        private void setFoodMode(Food datasBean) {
//            if (GSAApplication.tableContract.getTableType() == MealConstant.takeaway_food_mode) {
//                //外賣檯
//                if (datasBean.getItemtype() == 1 && datasBean.getFoodTableMode() == MealConstant.hall_food_mode) {
//                    tv_food_table_mode.setText(LanguageUtils.get_language_system(mContext, "food.table.mode.hall", "堂"));
//                    tv_food_table_mode.setVisibility(View.VISIBLE);
//                } else {
//                    tv_food_table_mode.setText("");
//                    tv_food_table_mode.setVisibility(View.GONE);
//                }
//            } else {
//                //堂食檯
//                if (datasBean.getItemtype() == 1 && datasBean.getFoodTableMode() == MealConstant.takeaway_food_mode) {
//                    tv_food_table_mode.setText(LanguageUtils.get_language_system(mContext, "food.table.mode.takeaway", "外"));
//                    tv_food_table_mode.setVisibility(View.VISIBLE);
//                } else {
//                    tv_food_table_mode.setText("");
//                    tv_food_table_mode.setVisibility(View.GONE);
//                }
//            }
        }

        private void setViewVisibility(Food datasBean) {

            tv_D.setVisibility(View.INVISIBLE);
            tv_D_1.setVisibility(View.INVISIBLE);
            tv_discount_money.setVisibility(View.INVISIBLE);

//            if (datasBean.isModify()) {
//                tv_modify_before_number.setText(String.valueOf(datasBean.getModifyBeforeNumber()));
//                tv_modify_before_number.setVisibility(View.VISIBLE);
//            } else {
//                tv_modify_before_number.setVisibility(View.INVISIBLE);
//            }
//
//            if (datasBean.getMix_DETAIL_ID() > 0) {
//                tv_mix.setText(String.valueOf(datasBean.getMix_DETAIL_ID()));
//                tv_mix.setVisibility(View.VISIBLE);
//            } else {
//                tv_mix.setVisibility(View.INVISIBLE);
//            }
        }

        private void setDSMark(Food datasBean) {
//            if (datasBean.isD_able() == false && !datasBean.getProp().equals("discount")) {
//                tv_D.setVisibility(View.VISIBLE);
//            } else {
//                tv_D.setVisibility(View.INVISIBLE);
//            }
//            if (datasBean.isDiscount_double1() == false && !datasBean.getProp().equals("discount")) {
//                tv_D_1.setVisibility(View.VISIBLE);
//            } else {
//                tv_D_1.setVisibility(View.INVISIBLE);
//            }
//            if (datasBean.isIsfood() == true && datasBean.getItemtype() <= 1) {
//                if (datasBean.isSc_able() == false) {
//                    tv_S.setVisibility(View.VISIBLE);
//                } else {
//                    tv_S.setVisibility(View.INVISIBLE);
//                }
//                if (datasBean.getDiscount_Fixed() == 6) {
//                    tv_S_1.setVisibility(View.VISIBLE);
//                } else {
//                    tv_S_1.setVisibility(View.INVISIBLE);
//                }
//            } else {
            tv_S.setVisibility(View.INVISIBLE);
            tv_S_1.setVisibility(View.INVISIBLE);
//            }
        }

        private void setName(Food datasBean) {
//            int flevel = datasBean.getItemtype();
            String name = datasBean.getFoodName();
//            switch (flevel) {
//                case 1:
//                    tv_number.setGravity(Gravity.LEFT);
//                    break;
//                case 2:
//                    name = "  " + name;
//                    tv_number.setGravity(Gravity.CENTER);
//                    break;
//                case 3:
//                    name = "      " + name;
//                    tv_number.setGravity(Gravity.RIGHT);
//                    break;
//            }
            tv_name.setText(name);

            boolean selected = datasBean.isSelected();
            if (selected) {
                //作为主体被选中 开启跑马灯效果
                tv_name.setFocusable(true);
                tv_name.setEllipsize(TextUtils.TruncateAt.MARQUEE);//设置旋转
                tv_name.setMarqueeRepeatLimit(-1);//-1为死循环，1为1次
                tv_name.setSelected(true);//设置不获取焦点就可以转
                tv_name.setFocusableInTouchMode(true);
            } else {
                //关闭跑马灯效果
                tv_name.setFocusable(false);
                tv_name.setMarqueeRepeatLimit(0);
                tv_name.setSelected(false);
                tv_name.setFocusableInTouchMode(false);
            }
        }

        private void setNumber(Food datasBean) {
            int number = datasBean.getNumber();
            if (number == 0) {
                //细项、折扣不需要显示数量
                tv_number.setText("");
            } else {
                tv_number.setText(String.valueOf(number));
            }
        }

        private void setMoney(Food datasBean) {
            double price = datasBean.getPrice();
            if (price != 0) {
                tv_money.setText(carshStr + MoneyUtil.get_ItemDecimals_money(price));
            } else {
                tv_money.setText("");
            }
        }

        private void setColor(Food datasBean) {

            boolean selected = datasBean.isSelected();

            //设置Item选中颜色
            if (!datasBean.isNew()) {

                iv_lock.setVisibility(View.INVISIBLE);
                rl_container.setBackgroundColor(ArmsUtils.getColor(mContext, R.color.theme_background_color));
                tv_name.setTextColor(ArmsUtils.getColor(mContext, R.color.Grass_green));
                tv_number.setTextColor(ArmsUtils.getColor(mContext, R.color.Grass_green));
                tv_money.setTextColor(ArmsUtils.getColor(mContext, R.color.Grass_green));

                if (selected) {
                    rl_container.setBackgroundColor(ArmsUtils.getColor(mContext, R.color.itemSelected));
                    rl_select.setBackgroundColor(ArmsUtils.getColor(mContext, R.color.itemSelected));// Color.YELLOW);
                    ll_tvname.setBackgroundResource(R.color.mainSelected);
                } else {
                    rl_container.setBackgroundColor(ArmsUtils.getColor(mContext, R.color.theme_white_color));
                    rl_select.setBackgroundColor(ArmsUtils.getColor(mContext, R.color.theme_white_color));
                    ll_tvname.setBackgroundColor(ArmsUtils.getColor(mContext, R.color.theme_white_color));
                }
            } else {
                iv_lock.setVisibility(View.INVISIBLE);

                rl_container.setBackgroundColor(ArmsUtils.getColor(mContext, R.color.theme_background_color));
                tv_name.setTextColor(ArmsUtils.getColor(mContext, R.color.theme_black));
                tv_number.setTextColor(ArmsUtils.getColor(mContext, R.color.theme_black));
                tv_money.setTextColor(ArmsUtils.getColor(mContext, R.color.theme_black));

                if (selected) {
                    rl_container.setBackgroundColor(ArmsUtils.getColor(mContext, R.color.itemSelected));
                    rl_select.setBackgroundColor(ArmsUtils.getColor(mContext, R.color.itemSelected));// Color.YELLOW);
                    ll_tvname.setBackgroundResource(R.color.mainSelected);
                } else {
                    rl_container.setBackgroundColor(ArmsUtils.getColor(mContext, R.color.theme_white_color));
                    rl_select.setBackgroundColor(ArmsUtils.getColor(mContext, R.color.theme_white_color));
                    ll_tvname.setBackgroundColor(ArmsUtils.getColor(mContext, R.color.theme_white_color));
                }

            }
        }

        public void setTextSize() {
            tv_money.setTextSize(BillListFontSize);
            tv_name.setTextSize(BillListFontSize);
            tv_number.setTextSize(BillListFontSize);
        }

    }

    private void setSelectPosition(int position) {
        resetSelected();
        select_position = position;
        mInfos.get(select_position).setIsSelected(true);
        notifyDataSetChanged();
    }

    public int addFoodItem(Food food) {

        select_position += 1;

        mInfos.add(food);

        setSelectPosition(select_position);

        return select_position;
    }

    /**
     * 長按刪除食品
     */
    public void removeAllNewFoodItem() {
        for (int i = mInfos.size() - 1; i >= 0; i--) {
            Food orderItem = mInfos.get(i);
            if (orderItem.isNew()) {
                mInfos.remove(i);
                notifyItemChanged(i);
                if (orderItem != null) {
                    Food orderBean = mPresenter.getOrderFoodById(orderItem.getId());
                    if (orderBean != null) {
                        mPresenter.setUserMaxQty(orderBean);
                    }
                }
            }
        }

        if (mInfos.size() == 0)
            //全部刪除
            return;

        mContext.showViewModeVisibility(MealConstant.food_group_ViewMode, MealConstant.food_ViewMode);
    }

    /**
     * 删除食品
     */
    public void removeFoodItem() {

        mInfos.remove(select_position);
        notifyItemChanged(select_position);

        if (mInfos.size() == 0) {
            //全部删除重置选中下标
            select_position = -1;
        } else {
            if (select_position == mInfos.size()) {
                select_position -= 1;
            }
        }

        mContext.showViewModeVisibility(MealConstant.food_group_ViewMode, MealConstant.food_ViewMode);
    }

    private void removeIntactFoodItem() {
        int start_position = select_full_start_position + 1;
        int end_position = select_full_end_position + 1;
        for (int i = mInfos.size() - 1; i >= 0; i--) {
            int my_index = mInfos.get(i).getMyIndex();
            if (start_position <= my_index && my_index <= end_position) {
                if (mInfos.get(i).isNew()) {
                    mInfos.remove(i);
                    notifyItemChanged(i);
                }
            }
        }
    }

    private void resetSelected() {
        for (int i = 0; i < mInfos.size(); i++) {
            Food food = mInfos.get(i);
            food.setIsSelected(false);
        }
    }

    public List<Food> getInfos() {
        return mInfos;
    }

    public int getSelect_position() {
        return select_position;
    }

    public void setSelect_position(int select_position) {
        this.select_position = select_position;
    }

    public void setSelect_end_position(int select_end_position) {
        this.select_end_position = select_end_position;
    }

    public int getSelect_start_position() {
        return select_start_position;
    }

    public int getSelect_end_position() {
        return select_end_position;
    }

    public int getSelect_full_start_position() {
        return select_full_start_position;
    }

    public int getSelect_full_end_position() {
        return select_full_end_position;
    }

    public int getMainStartPos() {
        return mainStartPos;
    }

    public int getMainEndPos() {
        return mainEndPos;
    }

    public Food getCurrentOrderDetail() {
        if (select_position != -1) {
            return mInfos.get(select_position);
        } else {
            return null;
        }
    }

    public Food getCurrentMainOrderDetail() {
        if (select_start_position != -1) {
            return mInfos.get(select_start_position);
        } else {
            return null;
        }
    }

    private OnItemClickListener mOnItemClickListener;

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        mOnItemClickListener = onItemClickListener;
    }

    public interface OnItemClickListener {

        void onItemClick(Food datasBean, int position);

    }

}
