package com.joe.print.print;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;

import com.joe.print.LayoutToBitmapUtils;
import com.joe.print.R;
import com.joe.print.adapter.BillAdapter;
import com.joe.print.adapter.FoodAdapter;
import com.joe.print.bean.BillingBean;
import com.joe.print.bean.FoodBean;
import com.joe.print.utils.BitmapUtil;
import com.joe.print.utils.ImageUtils;

import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;
import java.util.List;

import am.util.printer.PrintDataMaker;
import am.util.printer.PrinterUtils;
import am.util.printer.PrinterWriter;
import am.util.printer.PrinterWriter58mm;
import am.util.printer.PrinterWriter80mm;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

/**
 * Created by Wyh on 2020/1/9.
 * 送單打印
 */
public class SendPrint implements PrintDataMaker {

    private Context context;
    private int parting = 255;//高度分割值，
    private int width; // 打印的圖片寬度,紙張寬度

    public SendPrint(Context context, int parting, int width) {
        this.context = context;
        this.parting = parting;
        this.width = width;
    }

    @Override
    public List<byte[]> getPrintData(int type) {
        ArrayList<byte[]> data = new ArrayList<>();
        try {
            PrinterWriter printer;
            printer = type == PrinterWriter58mm.TYPE_58 ? new PrinterWriter58mm(parting, width) : new PrinterWriter80mm(parting, width);
            printer.setAlignCenter();

            data.add(printer.getDataAndReset());

            View view = initView();
            LayoutToBitmapUtils.layoutView(context, view);//先测量view
            Bitmap bitmap = LayoutToBitmapUtils.loadBitmapFromView(view);//将view轉bitmap

            //壓縮bitmap到指定大小
            bitmap = ImageUtils.scalingBitmap(bitmap, width);
            ArrayList<byte[]> image1 = PrinterUtils.decodeBitmapToDataList(bitmap, parting);//bitmap转字节码
            data.addAll(image1);

//            String bitmapPath = FileUtils.getExternalFilesDir(context, "Temp") + "tmp_qr.jpg";
//            if (QRCodeUtil.createQRImage(qr, 380, 380, null, bitmapPath)) {
//                ArrayList<byte[]> image2 = printer.getImageByte(bitmapPath);
//                data.addAll(image2);
//            } else {
//                ArrayList<byte[]> image2 = printer
//                        .getImageByte(context.getResources(), R.drawable.ic_printer_qr);
//                data.addAll(image2);
//            }
            printer.printLineFeed();
            printer.printLineFeed();
            printer.printLineFeed();
            printer.printLineFeed();
            printer.printLineFeed();
            printer.feedPaperCutPartial();
            data.add(printer.getDataAndClose());
            return data;
        } catch (Exception e) {
            return new ArrayList<>();
        }
    }

    @NotNull
    private View initView() {
        View view = LinearLayout.inflate(context, R.layout.print_layout_print, null);
        RecyclerView rvFood = view.findViewById(R.id.rv_food);
        RecyclerView rvBill = view.findViewById(R.id.rv_bill_amount);

        List<FoodBean> foodBeans = new ArrayList<>();
        foodBeans.add(new FoodBean("包子（主項）", 1, 13.54));
        foodBeans.add(new FoodBean("番薯爸爸", 2, 8.0));
        foodBeans.add(new FoodBean("包子（主項）", 3, 37.34));
        foodBeans.add(new FoodBean("測卡很快就酸辣粉十大減肥和思考", 33, 1334.2254));

        FoodAdapter foodAdapter = new FoodAdapter(foodBeans);
        rvFood.setLayoutManager(new LinearLayoutManager(context));
        rvFood.setAdapter(foodAdapter);


        List<BillingBean> billingBeans = new ArrayList<>();
        billingBeans.add(new BillingBean("合計", 58.88));
        billingBeans.add(new BillingBean("10%服務費", 5.08));
        billingBeans.add(new BillingBean("賬單小數", -0.06));
        billingBeans.add(new BillingBean("上課交電話費扣水電費可接受的咖啡機", 837248.8829372));

        BillAdapter billAdapter = new BillAdapter(billingBeans);
        rvBill.setLayoutManager(new LinearLayoutManager(context));
        rvBill.setAdapter(billAdapter);
        //加载条形码
        ImageView ivBarCode = view.findViewById(R.id.iv_bar_code);
        ivBarCode.setImageBitmap(BitmapUtil.generateBitmap("12312112131", 2, 450, 150));
        return view;
    }
}
