package com.gingersoft.gsa.cloud.table.mvp.contract;

import com.gingersoft.gsa.cloud.base.bean.BaseRespose;
import com.gingersoft.gsa.cloud.table.mvp.model.bean.TableBean;
import com.jess.arms.base.DefaultAdapter;
import com.jess.arms.mvp.IView;
import com.jess.arms.mvp.IModel;

import java.util.List;

import io.reactivex.Observable;
import okhttp3.RequestBody;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 12/27/2019 19:19
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public interface TableContract {
    //对于经常使用的关于UI的方法可以定义到IView中,如显示隐藏进度条,和显示文字消息
    interface View extends IView {

        void returnTableList(List<TableBean.DataBean> dataBeanList);

        void openTableItem(int id);

        void onStartRefreshTableData();

        void onPauseRefreshTableData();

        void setBottomFunctionAdapter(DefaultAdapter adapter);

        void setBottomFunctionRecycleLayoutManager(int orientation);
    }

    //Model层定义接口,外部只需关心Model返回的数据,无需关心内部细节,即是否使用缓存
    interface Model extends IModel {

        Observable<TableBean> getTables(int restaurantId);

        Observable<BaseRespose> openTable(RequestBody requestBody);

        Observable<Object> initTable(RequestBody requestBody);
    }
}
