package com.gingersoft.gsa.cloud.table.mvp.presenter;

import android.app.Application;
import android.content.Context;

import com.gingersoft.gsa.cloud.base.utils.VibratorUtils;
import com.gingersoft.gsa.cloud.base.utils.ViewUtils;
import com.gingersoft.gsa.cloud.table.mvp.model.bean.TableBean;
import com.gingersoft.gsa.cloud.table.mvp.ui.activity.TableActivity;
import com.gingersoft.gsa.cloud.table.mvp.ui.adapter.TableAdapter;
import com.gingersoft.gsa.cloud.table.mvp.ui.fragment.StateTableFragment;
import com.jess.arms.integration.AppManager;
import com.jess.arms.di.scope.FragmentScope;
import com.jess.arms.mvp.BasePresenter;
import com.jess.arms.http.imageloader.ImageLoader;

import me.jessyan.rxerrorhandler.core.RxErrorHandler;

import javax.inject.Inject;

import com.gingersoft.gsa.cloud.table.mvp.contract.StateTableContract;
import com.jess.arms.utils.DeviceUtils;

import java.util.ArrayList;
import java.util.List;

import static com.gingersoft.gsa.cloud.table.mvp.ui.activity.TableActivity.FUNCTION_STATE_TABLE;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 12/28/2019 17:33
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@FragmentScope
public class StateTablePresenter extends BasePresenter<StateTableContract.Model, StateTableContract.View> {
    @Inject
    RxErrorHandler mErrorHandler;
    @Inject
    Application mApplication;
    @Inject
    ImageLoader mImageLoader;
    @Inject
    AppManager mAppManager;

    private TableActivity mActivity;
    private StateTableFragment IView;

    private TableAdapter mTableAdapter;
    private List<TableBean.DataBean> mTableList = new ArrayList<>();

    @Inject
    public StateTablePresenter(StateTableContract.Model model, StateTableContract.View rootView) {
        super(model, rootView);
        this.IView = (StateTableFragment) rootView;
        this.mActivity = (TableActivity) IView.getActivity();
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mErrorHandler = null;
        this.mAppManager = null;
        this.mImageLoader = null;
        this.mApplication = null;
    }

    public void initTableAdapter(Context context) {
        if (mTableAdapter == null) {
            mTableAdapter = new TableAdapter(context, mTableList, DeviceUtils.getScreenHeight(mApplication), FUNCTION_STATE_TABLE);
            mTableAdapter.setStyle(0);
            mRootView.setStateTableAdapter(mTableAdapter);
            initItemClickListener(context);
        }
    }

    /**
     * 更新所有餐台数据
     *
     * @param context
     * @param tableList
     */
    public void updateAllTableData(Context context, List<TableBean.DataBean> tableList, int status) {
        this.mActivity = (TableActivity) context;
        if (tableList != null) {
            //这里先清空
            mTableList.clear();
            if (status == 1) {
                //显示全部台号 按照狀態排序
                initTableByStauts(tableList);
            } else {
                //根据状态只显示相应状态台号
                filterTableByTableStatus(tableList, status);
            }
            initTableAdapter(context);
            mTableAdapter.notifyDataSetChanged();
        }

    }

    /**
     * 更新状态以改变餐台
     *
     * @param newTableList
     */
    public void updataTableItem(List<TableBean.DataBean> newTableList) {
//        for (int i = 0; i < newTableList.size(); i++) {
//            TableBean.DataBean newTableBean = newTableList.get(i);
//            for (int j = 0; j < mTableList.size(); j++) {
//                TableBean.DataBean tableBean = mTableList.get(j);
//                if (tableBean.getTableno() == newTableBean.getTableno()) {
//                    tableBean.setOrderid(newTableBean.getOrderid());
//                    tableBean.setOrderid_1(newTableBean.getOrderid_1());
//                    tableBean.setStatus(newTableBean.getStatus());
//                    tableBean.setUsing(newTableBean.isUsing());
//                    tableBean.setMainshowtable(newTableBean.getMainshowtable());
//                    tableBean.setSplitStatus(newTableBean.getSplitStatus());
//                    tableBean.setOropentime_diff(newTableBean.getOropentime_diff());
//                    tableBean.setPrtime_diff(newTableBean.getPrtime_diff());
//                    tableBean.setClearstate(newTableBean.getClearstate());
//                    tableBean.setOpentime(newTableBean.getOpentime());
//                    tableBean.setMemid(newTableBean.getMemid());
//                    tableBean.setSc_rate(newTableBean.getSc_rate());
//                    tableBean.setPax(newTableBean.getPax());
//                    tableBean.setQr_code(newTableBean.getQr_code());
//                    tableBean.setRiceponorderid(newTableBean.getRiceponorderid());
//
//                    mTableAdapter.notifyItemChanged(j);
//                }
//            }
//        }
    }

    /**
     * 根据餐台状态 过滤餐台
     *
     * @param status 0=可使用, 2=已送單,3=已印單, 4=已結帳(清檯), 5=分單(現已停用, 改為使用splitstatus), 6=連檯, 7=暫未使用
     */
    public void filterTableByTableStatus(List<TableBean.DataBean> datasBeans, int status) {
        if (datasBeans.size() == 0) {
            return;
        }
        switch (status) {
            case 0:
                for (int i = 0; i < datasBeans.size(); i++) {
                    if (datasBeans.get(i).getStatus() > 0 && datasBeans.get(i).getStatus() < 4) {
                        mTableList.add(datasBeans.get(i));
                    }
                }
                break;
//            case 1:
//                mTableList.addAll(datasBeans);
//                break;
            case 2:
                for (int i = 0; i < datasBeans.size(); i++) {
                    if (datasBeans.get(i).getStatus() == 0) {
                        mTableList.add(datasBeans.get(i));
                    }
                }
                break;
            case 3:
                for (int i = 0; i < datasBeans.size(); i++) {
                    if (datasBeans.get(i).getStatus() == 1) {
                        mTableList.add(datasBeans.get(i));
                    }
                }
                break;
            case 4:
                for (int i = 0; i < datasBeans.size(); i++) {
                    if (datasBeans.get(i).getStatus() == 2 && datasBeans.get(i).getStatus() != 1) {
                        mTableList.add(datasBeans.get(i));
                    }
                }
                break;
            case 5:
                for (int i = 0; i < datasBeans.size(); i++) {
                    if (datasBeans.get(i).getStatus() == 3) {
                        mTableList.add(datasBeans.get(i));
                    }
                }
                break;
            case 6:
                for (int i = 0; i < datasBeans.size(); i++) {
//                    if (datasBeans.get(i).getSplitStatus() == 1) {
                    mTableList.add(datasBeans.get(i));
//                    }
                }
                break;
        }
    }


    private void initTableByStauts(List<TableBean.DataBean> tableList) {

        List<TableBean.DataBean> tb_yellow = new ArrayList<>();
        List<TableBean.DataBean> tb_green = new ArrayList<>();
        List<TableBean.DataBean> tb_red = new ArrayList<>();
        List<TableBean.DataBean> tb_blue = new ArrayList<>();
        List<TableBean.DataBean> tb_w6 = new ArrayList<>();
        List<TableBean.DataBean> tb_unkown = new ArrayList<>();
        //黃色=状态=3 , 綠色=2, 紅色=using=1, 藍色=0

        for (TableBean.DataBean datasBean : tableList) {
            if (datasBean.getStatus() == 1) {
                tb_red.add(datasBean);
            } else {
                switch (datasBean.getStatus()) {
                    case 0:
                        tb_blue.add(datasBean);
                        break;
                    case 2:
                        tb_green.add(datasBean);
                        break;
                    case 3:
                        tb_yellow.add(datasBean);
                        break;
                    case 6:
                        tb_w6.add(datasBean);
                        break;
                    default:
                        tb_unkown.add(datasBean);
                        break;
                }
            }
        }
//        if (GSAApplication.tableContract.getTime_foropentable() == true) {
        mTableList.addAll(tb_yellow);
        mTableList.addAll(tb_green);
        mTableList.addAll(tb_red);
        mTableList.addAll(tb_w6);
//        } else {
//            mTableList.addAll(tb_w6);
//            mTableList.addAll(tb_red);
//            mTableList.addAll(tb_green);
//            mTableList.addAll(tb_yellow);
//        }
        mTableList.addAll(tb_unkown);
        mTableList.addAll(tb_blue);
    }

    private void initItemClickListener(Context context) {
        mTableAdapter.setOnItemClickListener(new TableAdapter.OnItemClickListener() {

            @Override
            public void onItemClick(TableBean.DataBean item, int position) {

                if (ViewUtils.isFastClick2()) {

                    VibratorUtils.pressButtonSound(mApplication);

                    mActivity.openTableItem(item.getId());
                }
            }
        });
    }

}
