package com.gingersoft.gsa.cloud.table.di.module;

import com.gingersoft.gsa.cloud.database.bean.Food;
import com.gingersoft.gsa.cloud.table.mvp.contract.SetMealContract;
import com.gingersoft.gsa.cloud.table.mvp.ui.adapter.MemberInfoAdapter;
import com.gingersoft.gsa.cloud.table.mvp.ui.adapter.meal.FoodGroupAdapter;
import com.gingersoft.gsa.cloud.ui.bean.view.SectionTextItem;
import com.jess.arms.di.scope.FragmentScope;

import dagger.Binds;
import dagger.Module;
import dagger.Provides;

import com.gingersoft.gsa.cloud.table.mvp.contract.RiceponMemberDialogContract;
import com.gingersoft.gsa.cloud.table.mvp.model.RiceponMemberDialogModel;

import java.util.ArrayList;
import java.util.List;

import javax.inject.Named;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 04/24/2021 16:24
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@Module
public abstract class RiceponMemberDialogModule {

    @Binds
    abstract RiceponMemberDialogContract.Model bindRiceponMemberDialogModel(RiceponMemberDialogModel model);

    @FragmentScope
    @Provides
    static List<SectionTextItem> provideMemberInfoList() {
        return new ArrayList<>();
    }

    @FragmentScope
    @Provides
    static MemberInfoAdapter provideMemberInfoAdapter(List<SectionTextItem> memberInfoList) {
        return new MemberInfoAdapter(memberInfoList);
    }
}