package com.gingersoft.gsa.cloud.table.mvp.model;

import android.app.Application;

import com.gingersoft.gsa.cloud.database.bean.Modifier;
import com.gingersoft.gsa.cloud.database.utils.ModifierDaoUtils;
import com.gingersoft.gsa.cloud.table.mvp.contract.FineChildAllContract;
import com.gingersoft.gsa.cloud.table.mvp.model.utils.MealStyleUtils;
import com.google.gson.Gson;
import com.jess.arms.di.scope.FragmentScope;
import com.jess.arms.integration.IRepositoryManager;
import com.jess.arms.mvp.BaseModel;

import java.util.List;

import javax.inject.Inject;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 02/19/2020 22:15
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@FragmentScope
public class FineChildAllModel extends BaseModel implements FineChildAllContract.Model {
    @Inject
    Gson mGson;
    @Inject
    Application mApplication;

    @Inject
    public FineChildAllModel(IRepositoryManager repositoryManager) {
        super(repositoryManager);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mGson = null;
        this.mApplication = null;
    }

    @Override
    public List<Modifier> queryDB_ModifierByModMsgAndVisibleQueryBuilder() {
        //获取数据
        ModifierDaoUtils modifierDaoUtils = new ModifierDaoUtils(mApplication);
        List<Modifier> modifierList = modifierDaoUtils.queryModifierByModMsgAndVisibleQueryBuilder();
        return MealStyleUtils.assemblyModifiersColor(modifierList);
    }

    @Override
    public List<Modifier> queryDB_ModifierByModModTasteVisibleQueryBuilder() {
        ModifierDaoUtils modifierDaoUtils = new ModifierDaoUtils(mApplication);
        List<Modifier> modifierList = modifierDaoUtils.queryModifierByModModTasteVisibleQueryBuilder();
        return MealStyleUtils.assemblyModifiersColor(modifierList);
    }

    @Override
    public List<Modifier> queryDB_ModifierByModModCommVisibleQueryBuilder() {
        ModifierDaoUtils modifierDaoUtils = new ModifierDaoUtils(mApplication);
        List<Modifier> modifierList = modifierDaoUtils.queryModifierByModModCommVisibleQueryBuilder();
        return MealStyleUtils.assemblyModifiersColor(modifierList);
    }

    @Override
    public List<Modifier> queryDB_ModifierByTopidAndVisibleQueryBuilder(long fid) {
        ModifierDaoUtils modifierDaoUtils = new ModifierDaoUtils(mApplication);
        List<Modifier> modifierList = modifierDaoUtils.queryModifierByTopidAndVisibleQueryBuilder(fid);
        return MealStyleUtils.assemblyModifiersColor(modifierList);
    }
}