package com.gingersoft.gsa.cloud.table.mvp.model;

import android.app.Application;

import com.gingersoft.gsa.cloud.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.common.rxjava.MyRxSchedulerUtils;
import com.gingersoft.gsa.cloud.database.bean.ComboItem;
import com.gingersoft.gsa.cloud.database.bean.Food;
import com.gingersoft.gsa.cloud.database.bean.FoodCombo;
import com.gingersoft.gsa.cloud.database.bean.FoodModifier;
import com.gingersoft.gsa.cloud.database.bean.Modifier;
import com.gingersoft.gsa.cloud.database.utils.ComboItemDaoUtils;
import com.gingersoft.gsa.cloud.database.utils.FoodComboDaoUtils;
import com.gingersoft.gsa.cloud.database.utils.FoodDaoUtils;
import com.gingersoft.gsa.cloud.database.utils.ModifierDaoUtils;
import com.gingersoft.gsa.cloud.table.mvp.model.bean.response.BaseOrderResponse;
import com.gingersoft.gsa.cloud.table.mvp.model.utils.MealConditionFilterUtils;
import com.gingersoft.gsa.cloud.table.mvp.model.utils.MealStyleUtils;
import com.google.gson.Gson;
import com.jess.arms.integration.IRepositoryManager;
import com.jess.arms.mvp.BaseModel;

import com.jess.arms.di.scope.FragmentScope;

import javax.inject.Inject;

import com.gingersoft.gsa.cloud.table.mvp.contract.SetMealContract;

import java.util.List;

import io.reactivex.Observable;
import io.reactivex.Single;
import okhttp3.RequestBody;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 04/17/2021 10:40
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@FragmentScope
public class SetMealModel extends BaseModel implements SetMealContract.Model {
    @Inject
    Gson mGson;
    @Inject
    Application mApplication;

    @Inject
    public SetMealModel(IRepositoryManager repositoryManager) {
        super(repositoryManager);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mGson = null;
        this.mApplication = null;
    }

    @Override
    public Single<List<Food>> queryDB_FoodGroupList(int foodSummary) {
        FoodDaoUtils foodDaoUtils = new FoodDaoUtils(mApplication);
        List<Food> foods = foodDaoUtils.queryFoodGroupByQueryBuilder(foodSummary);
        return Single.just(
                MealStyleUtils.assemblyFoodsColor(
                MealConditionFilterUtils.foodConditionFilter(foods, foodSummary)))
                .compose(MyRxSchedulerUtils._io_main_f());
    }

    @Override
    public Single<List<Food>> queryDB_FoodList(long parentId, int foodSummary) {
        FoodDaoUtils foodDaoUtils = new FoodDaoUtils(mApplication);
        List<Food> foods = foodDaoUtils.queryFoodByQueryBuilder(parentId, foodSummary);
        return Single.just(MealStyleUtils.assemblyFoodsColor(MealConditionFilterUtils.foodConditionFilter(foods, foodSummary)))
                .compose(MyRxSchedulerUtils._io_main_f());
    }

    @Override
    public List<Modifier> queryDB_ModifierList(long fid, int mode) {
        ModifierDaoUtils daoUtils = new ModifierDaoUtils(mApplication);
        List<Modifier> modifierList = daoUtils.queryModifiersByFid(fid, mode);
        return MealStyleUtils.assemblyModifiersColor(modifierList);
    }

    @Override
    public List<ComboItem> queryDB_ComboList(long fid, int foodSummary) {
        ComboItemDaoUtils comboItemDao = new ComboItemDaoUtils(mApplication);
        List<ComboItem> foodCombos = comboItemDao.queryComboItemsByFidQueryBuilder(fid, foodSummary);
        return MealConditionFilterUtils.comboConditionFilter(foodCombos, foodSummary);
    }

    @Override
    public Single<List<FoodCombo>> isComboFood(long fid) {
        FoodComboDaoUtils foodComboDaoUtils = new FoodComboDaoUtils(mApplication);
        return Single.just(foodComboDaoUtils.queryCombosFoodsByQueryBuilder(fid))
                .compose(MyRxSchedulerUtils._io_main_f());
    }

    @Override
    public Single<List<FoodModifier>> queryDB_FoodModifierList(long fid) {
        return null;
    }

    @Override
    public Observable<BaseResult> toOrderPay(RequestBody requestBody) {
        return null;
    }

    @Override
    public Observable<BaseResult> updateOrder(RequestBody formBody) {
        return null;
    }

    @Override
    public Observable<BaseOrderResponse> calculationPrice(long orderId) {
        return null;
    }
}