package com.gingersoft.gsa.cloud.pay.device.pos.yedpay;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;

import androidx.fragment.app.Fragment;

import com.gingersoft.gsa.cloud.pay.RequestParms;
import com.gingersoft.gsa.cloud.pay.device.pos.yedpay.constant.YedpayConstant;
import com.gingersoft.gsa.cloud.pay.lifecycle.presenter.PayFlowPresenter;

import java.lang.ref.WeakReference;

/**
 * @作者: bin
 * @創建時間: 2021-04-23 9:55
 * @更新時間: 2021-04-23 9:55
 * @描述:
 */
public class YedpayCallbackImp implements YedpayCallback {

    private WeakReference<Fragment> mContext;
    private WeakReference<PayFlowPresenter> mPayFlowPresenter;
    private RequestParms mRequestParms;

    public YedpayCallbackImp(Fragment context, PayFlowPresenter payFlowPresenter, RequestParms requestParms) {
        this.mContext = new WeakReference<>(context);
        this.mPayFlowPresenter = new WeakReference<>(payFlowPresenter);
        this.mRequestParms = requestParms;
    }

    @Override
    public void callSaleUri(String uri) {
        Fragment fragment = mContext.get();
        if (fragment != null) {
            Uri uri2 = Uri.parse(uri);
            Intent intent = new Intent(Intent.ACTION_VIEW, uri2);
            fragment.startActivityForResult(intent, YedpayConstant.CallRequestCode.SALE_REQUEST_CODE);
        }
    }

    @Override
    public void refundResult(boolean result) {
        PayFlowPresenter payFlowPresenter = mPayFlowPresenter.get();
        if (payFlowPresenter != null && mRequestParms != null) {
            payFlowPresenter.yedPayRefundOrder(mRequestParms.getRefundReason(), mRequestParms.getOrderId(), mRequestParms.getPayType(), mRequestParms.getResturantId());
        }
    }

}
