package com.gingersoft.gsa.cloud.ui.adapter.bean;

import android.view.inputmethod.EditorInfo;

import java.util.List;

import lombok.Data;
import me.yokeyword.fragmentation.ISupportFragment;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/11/20
 * Time: 10:45
 * Use: 多功能列表item實體類，多功能adapter使用
 */
public class InfoMultiBean {
    /**
     * 顯示一條分割線
     */
    public static final int ITEM_TYPE_LINE = 0;

    /**
     * 顯示一條字體加粗的標題
     */
    public static final int ITEM_TYPE_TITLE = 1;
    /**
     * 進入下一頁面的選擇類型，有輸入框
     */
    public final static int EDIT_FOOD_ITEM_SELECT = 2;
    /**
     * 選中時顯示列表，如果不添加列表數據，則是單選按鈕
     */
    public static final int ITEM_TYPE_SHOW_LIST = 4;
    /**
     * 上傳圖片
     */
    public final static int EDIT_FOOD_ITEM_UPLOAD_PIC = 5;
    /**
     * 選中時顯示彈窗
     */
    public static final int ITEM_TYPE_SHOW_DIALOG = 6;
    /**
     * 顯示輸入框
     */
    public static final int ITEM_TYPE_INPUT = 7;

    /**
     * 輸入框，並且可跳轉到其他頁面
     */
//    public final static int ITEM_MULTIPLE_INPUT_SELECT = 8;

    /**
     * 備註輸入框樣式
     */
    public final static int ITEM_MULTIPLE_INPUT_REMARK = 9;

    /**
     * 複選框樣式
     */
    public final static int ITEM_MULTIPLE_CHECKBOX = 10;
    /**
     * 是否切換按鈕樣式
     */
    public final static int ITEM_MULTIPLE_BOOLEAN = 11;

    /**
     * item類型
     */
    public int itemType;
    /**
     * 用於顯示的標題
     */
    private String showTitle;
    /**
     * 是否必填
     */
    private boolean isRequired;

    /**
     * 提示文字
     */
    private String hintText;

    /**
     * 顯示的值
     */
    private String showValue;

    /**
     * 選中狀態
     */
    private boolean isChecked;
    /**
     * 當類型為輸入框時，限制輸入的內容格式
     */
    private int inputType = EditorInfo.TYPE_CLASS_TEXT;
    private int maxLength = 50;
    /**
     * 點擊展開有其他item
     */
    private List<InfoMultiBean> infoMultiBeans;

    protected Class<? extends ISupportFragment> fragment;

    public InfoMultiBean() {
    }

    public InfoMultiBean(int itemType) {
        this.itemType = itemType;
    }

    public InfoMultiBean(int itemType, String showTitle, boolean isRequired, String hintText, String showValue) {
        this.itemType = itemType;
        this.showTitle = showTitle;
        this.isRequired = isRequired;
        this.hintText = hintText;
        this.showValue = showValue;
    }

    public InfoMultiBean(int itemType, String showTitle) {
        this.itemType = itemType;
        this.showTitle = showTitle;
    }

    public InfoMultiBean(int itemType, String showTitle, boolean isRequired, String hintText) {
        this.itemType = itemType;
        this.showTitle = showTitle;
        this.isRequired = isRequired;
        this.hintText = hintText;
    }

    public InfoMultiBean(int itemType, String showTitle, boolean isRequired, boolean isChecked) {
        this.itemType = itemType;
        this.showTitle = showTitle;
        this.isRequired = isRequired;
        this.isChecked = isChecked;
    }

    public InfoMultiBean(int itemType, String showTitle, String hintText, Class<? extends ISupportFragment> supportFragment) {
        this.itemType = itemType;
        this.showTitle = showTitle;
        this.hintText = hintText;
        this.fragment = supportFragment;
    }

    public InfoMultiBean(int itemType, String showTitle, boolean isRequired, String hintText, Class<? extends ISupportFragment> fragment) {
        this.itemType = itemType;
        this.showTitle = showTitle;
        this.isRequired = isRequired;
        this.hintText = hintText;
        this.fragment = fragment;
    }

    public InfoMultiBean(int itemType, String showTitle, boolean isRequired) {
        this.itemType = itemType;
        this.showTitle = showTitle;
        this.isRequired = isRequired;
    }

//    public String getShowValue() {
//        if(showValue == null){
//            return "";
//        }
//        return showValue;
//    }


    public boolean isChecked() {
        return isChecked;
    }

    public void setChecked(boolean checked) {
        isChecked = checked;
    }

    public int getItemType() {
        return itemType;
    }

    public void setItemType(int itemType) {
        this.itemType = itemType;
    }

    public String getShowTitle() {
        return showTitle;
    }

    public void setShowTitle(String showTitle) {
        this.showTitle = showTitle;
    }

    public boolean isRequired() {
        return isRequired;
    }

    public void setRequired(boolean required) {
        isRequired = required;
    }

    public String getHintText() {
        return hintText;
    }

    public void setHintText(String hintText) {
        this.hintText = hintText;
    }

    public String getShowValue() {
        return showValue;
    }

    public void setShowValue(String showValue) {
        this.showValue = showValue;
    }

    public int getInputType() {
        return inputType;
    }

    public InfoMultiBean setInputType(int inputType) {
        this.inputType = inputType;
        return this;
    }

    public int getMaxLength() {
        return maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public List<InfoMultiBean> getInfoMultiBeans() {
        return infoMultiBeans;
    }

    public void setInfoMultiBeans(List<InfoMultiBean> infoMultiBeans) {
        this.infoMultiBeans = infoMultiBeans;
    }

    public Class<? extends ISupportFragment> getFragment() {
        return fragment;
    }

    public void setFragment(Class<? extends ISupportFragment> fragment) {
        this.fragment = fragment;
    }
}
