package com.gingersoft.coldchain_module.di.module;

import com.gingersoft.coldchain_module.mvp.contract.ColdChainMainContract;
import com.gingersoft.coldchain_module.mvp.model.ColdChainMainModel;
import com.jess.arms.di.scope.ActivityScope;

import dagger.Module;
import dagger.Provides;


@Module
public class ColdChainMainModule {
    private ColdChainMainContract.View view;

    /**
     * 构建MainModule时,将View的实现类传进来,这样就可以提供View的实现类给presenter
     *
     * @param view
     */
    public ColdChainMainModule(ColdChainMainContract.View view) {
        this.view = view;
    }

    @ActivityScope
    @Provides
    ColdChainMainContract.View provideMainView() {
        return this.view;
    }

    @ActivityScope
    @Provides
    ColdChainMainContract.Model provideMainModel(ColdChainMainModel model) {
        return model;
    }
}