package com.gingersoft.supply_chain.mvp.ui.adapter;

import android.content.Context;
import android.os.Looper;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.arch.core.executor.TaskExecutor;

import com.gingersoft.gsa.cloud.common.utils.glide.GlideUtils;
import com.gingersoft.gsa.cloud.common.utils.other.TextUtil;
import com.gingersoft.gsa.cloud.common.utils.threadPool.ThreadPoolManager;
import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.mvp.bean.BuyIngredientsBean;
import com.gingersoft.supply_chain.mvp.bean.PurchaseFoodBean;
import com.xuexiang.rxutil2.rxjava.RxJavaUtils;
import com.xuexiang.rxutil2.rxjava.task.RxIOTask;
import com.xuexiang.rxutil2.rxjava.task.RxUITask;

import java.util.ArrayList;
import java.util.List;

/**
 * @author 宇航.
 * User: admin
 * Date: 2021/3/11
 * Time: 16:18
 * Use: 食材列表
 */
public class BuyIngredientsAdapter extends GroupedRecyclerViewAdapter {

    private List<BuyIngredientsBean> buyIngredientsBeans;
    private boolean isSinger = true;
    private OnFoodNumberChangeListener onFoodNumberChangeListener;
    private boolean longClick = false;
    private int delayTime = 500;

    public BuyIngredientsAdapter(Context context, List<BuyIngredientsBean> buyIngredientsBeans) {
        super(context);
        this.buyIngredientsBeans = buyIngredientsBeans;
    }

    public void setShowSingerRow(boolean showType) {
        isSinger = showType;
    }

    public BuyIngredientsBean getHeaderDataByPosition(int position) {
        if (position < buyIngredientsBeans.size()) {
            return buyIngredientsBeans.get(position);
        }
        return null;
    }

    @Override
    public int getGroupCount() {
        return buyIngredientsBeans == null ? 0 : buyIngredientsBeans.size();
    }

    @Override
    public int getChildrenCount(int groupPosition) {
        BuyIngredientsBean buyIngredientsBean = buyIngredientsBeans.get(groupPosition);
        return buyIngredientsBean.purchaseFoodList == null ? 0 : buyIngredientsBean.purchaseFoodList.size();
    }

    @Override
    public boolean hasHeader(int groupPosition) {
        return true;
    }

    @Override
    public boolean hasFooter(int groupPosition) {
        return false;
    }

    @Override
    public int getHeaderLayout(int viewType) {
        return R.layout.item_buy_food_ingredient_header;
    }

    @Override
    public int getFooterLayout(int viewType) {
        return 0;
    }

    @Override
    public int getChildLayout(int viewType) {
        return getLayoutId();
    }

    @Override
    public void onBindHeaderViewHolder(BaseViewHolder holder, int groupPosition) {
        holder.setText(R.id.tv_buy_food_header, buyIngredientsBeans.get(groupPosition).categoryName);
    }

    @Override
    public void onBindFooterViewHolder(BaseViewHolder holder, int groupPosition) {

    }

    @Override
    public void onBindChildViewHolder(BaseViewHolder itemViewHolder, int groupPosition, int childPosition) {
        PurchaseFoodBean purchaseFoodBean = buyIngredientsBeans.get(groupPosition).purchaseFoodList.get(childPosition);
        itemViewHolder.setText(R.id.tv_food_item_supplier_name, purchaseFoodBean.getSupplierName());
        itemViewHolder.setImageResource(R.id.iv_food_ingredient_img, R.drawable.img_small_default);
        if (TextUtil.isNotEmptyOrNullOrUndefined(purchaseFoodBean.getImages())) {
            GlideUtils.display(mContext, (ImageView) itemViewHolder.get(R.id.iv_food_ingredient_img), purchaseFoodBean.getImages());
        }
        itemViewHolder.setText(R.id.tv_food_item_no, purchaseFoodBean.getFoodNo());
        itemViewHolder.setText(R.id.tv_food_item_name, purchaseFoodBean.getName());
        //如果有包裝描述就顯示包裝描述，沒有包裝描述顯示基本單位
        if (TextUtil.isNotEmptyOrNullOrUndefined(purchaseFoodBean.getPackingDescription())) {
            itemViewHolder.setText(R.id.tv_food_item_unit, purchaseFoodBean.getPackingDescription());
        } else {
            itemViewHolder.setText(R.id.tv_food_item_unit, purchaseFoodBean.getBasicUnitName());
        }
        itemViewHolder.setText(R.id.tv_food_item_price, String.format(mContext.getString(R.string.amount_string), purchaseFoodBean.getUnitPrice()));
        itemViewHolder.setText(R.id.ed_food_ingredient_number, String.valueOf(purchaseFoodBean.getFoodQuantity()), TextView.BufferType.EDITABLE);

        EditText edNumberInput = (EditText) itemViewHolder.get(R.id.ed_food_ingredient_number);
        //如果數量小於等於0，就不顯示減號和數量
        setSubAndNumShow(itemViewHolder, purchaseFoodBean.getFoodQuantity() <= 0);
        //編輯數量
        itemViewHolder.setOnClickListener(R.id.btn_food_operation_sub, v -> {
            //食材數量減少
            if (purchaseFoodBean.getFoodQuantity() > 0) {
                purchaseFoodBean.setFoodQuantity(purchaseFoodBean.getFoodQuantity() - 1);
                itemViewHolder.setText(R.id.ed_food_ingredient_number, String.valueOf(purchaseFoodBean.getFoodQuantity()));
            }
            if (onFoodNumberChangeListener != null) {
                onFoodNumberChangeListener.onChange(groupPosition, childPosition, purchaseFoodBean.getFoodQuantity() + 1, purchaseFoodBean.getFoodQuantity());
            }
            //改變減號和數量的顯示
            setSubAndNumShow(itemViewHolder, purchaseFoodBean.getFoodQuantity() <= 0);
        }).setOnClickListener(R.id.btn_food_operation_add, v -> {
            //食材數量增加
            purchaseFoodBean.setFoodQuantity(purchaseFoodBean.getFoodQuantity() + 1);
            itemViewHolder.setText(R.id.ed_food_ingredient_number, String.valueOf(purchaseFoodBean.getFoodQuantity()));
            setSubAndNumShow(itemViewHolder, false);
            if (onFoodNumberChangeListener != null) {
                onFoodNumberChangeListener.onChange(groupPosition, childPosition, purchaseFoodBean.getFoodQuantity() - 1, purchaseFoodBean.getFoodQuantity());
            }
        }).setOnTouchListener(R.id.btn_food_operation_sub, onBtnTouchListener).setOnLongClickListener(R.id.btn_food_operation_sub, v -> {
            //開啟線程
            setLongClick(itemViewHolder, edNumberInput, purchaseFoodBean, false);
            return true;
        }).setOnTouchListener(R.id.btn_food_operation_add, onBtnTouchListener).setOnLongClickListener(R.id.btn_food_operation_add, v -> {
            setLongClick(itemViewHolder, edNumberInput, purchaseFoodBean, true);
            return true;
        });
        //輸入框焦點監聽
//        itemViewHolder.setOnFocusChangeListener(R.id.ed_food_ingredient_number, (v, hasFocus) -> {
//            CharSequence text = itemViewHolder.getText(R.id.ed_food_ingredient_number);
//            if (!hasFocus) {
//                //當失去焦點時，如果沒有食品數量了，就隱藏減號和輸入框
//                if (TextUtil.isEmptyOrNullOrUndefined(text) || Integer.parseInt(text.toString()) == 0) {
//                    setSubAndNumShow(itemViewHolder, false);
//                }
//            }
//        });

    }

    /**
     * 設置減少按鈕和輸入框的顯示或隱藏
     *
     * @param showOrHide 顯示或隱藏 true隱藏，false顯示
     */
    private void setSubAndNumShow(BaseViewHolder viewHolder, boolean showOrHide) {
        viewHolder.setVisible(R.id.btn_food_operation_sub, !showOrHide);
        viewHolder.setInvisible(R.id.ed_food_ingredient_number, showOrHide);
    }

    /**
     * + - 按鈕觸摸事件
     */
    private View.OnTouchListener onBtnTouchListener = (v, event) -> {
        if (event.getAction() == MotionEvent.ACTION_DOWN) {
            longClick = true;
        } else if (event.getAction() == MotionEvent.ACTION_UP) {
            longClick = false;
        }
        return false;
    };

    /**
     * 按鈕長按事件
     *
     * @param edNumberInput    輸入框
     * @param purchaseFoodBean 商品信息
     * @param addOrSub         是+ or -
     */
    public void setLongClick(BaseViewHolder itemViewHolder, EditText edNumberInput, PurchaseFoodBean purchaseFoodBean, boolean addOrSub) {
        //開啟線程
        ThreadPoolManager.getInstence().putExecutableTasks(() -> {
            int number = 0;
            if (TextUtil.isNotEmptyOrNullOrUndefined(edNumberInput)) {
                number = Integer.parseInt(edNumberInput.getText().toString());
            }
            delayTime = 500;
            if (addOrSub) {
                //+
                if (number == 0) {
                    //如果數量為0，先把減號和數量顯示出來
                    edNumberInput.post(() -> setSubAndNumShow(itemViewHolder, false));
                }
                while (longClick) {
                    if (number < 9999) {
                        try {
                            Thread.sleep(delayTime);
                            number++;
                            if (delayTime > 100) {
                                delayTime -= 100;
                            }
                            int finalNumber = number;
                            edNumberInput.post(() -> edNumberInput.setText(String.valueOf(finalNumber)));
                            Log.e("eee", "食材數量加加減減：" + finalNumber);
                        } catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    } else {
                        longClick = false;
                    }
                }
            } else {
                //-
                while (longClick) {
                    if (number > 0) {
                        try {
                            Thread.sleep(delayTime);
                            number--;
                            if (delayTime > 100) {
                                delayTime -= 100;
                            }
                            int finalNumber = number;
                            edNumberInput.post(() -> edNumberInput.setText(String.valueOf(finalNumber)));
                        } catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    } else {
                        longClick = false;
                        edNumberInput.post(() -> setSubAndNumShow(itemViewHolder, true));
                    }
                }
            }
            purchaseFoodBean.setFoodQuantity(number);
        });
    }

    public interface OnFoodNumberChangeListener {
        /**
         * 數量改變
         *
         * @param parentCategoryIndex 所屬分類下標
         * @param categoryIndex       食材在分類中的下標
         * @param beforeNum           之前的數量
         * @param currentNum          現在的數量
         */
        void onChange(int parentCategoryIndex, int categoryIndex, int beforeNum, int currentNum);
    }

    public void setOnFoodNumberChangeListener(OnFoodNumberChangeListener onFoodNumberChangeListener) {
        this.onFoodNumberChangeListener = onFoodNumberChangeListener;
    }

    public int getLayoutId() {
        if (isSinger) {
            return R.layout.item_buy_food_ingredient;
        }
        return R.layout.item_buy_food_ingredient_double_row;
    }

    public void setData(List<BuyIngredientsBean> buyIngredientsBeans) {
        this.buyIngredientsBeans = buyIngredientsBeans;
        notifyDataSetChanged();
    }
}
