package com.gingersoft.supply_chain.mvp.ui.adapter;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.widget.TextView;

import androidx.cardview.widget.CardView;
import androidx.core.content.ContextCompat;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.common.R;
import com.gingersoft.gsa.cloud.ui.bean.view.CategoryBean;
import com.gingersoft.supply_chain.mvp.bean.OrderCategoryBean;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/11/28
 * Time: 11:45
 * Use: 一級分類
 */
public class FirstLevelCategoryAdapter extends BaseQuickAdapter<OrderCategoryBean.FoodCategoryTrees, BaseViewHolder> {

    private int selectedIndex = 0;
    private Drawable selectedBg;
    private Drawable unSelectedBg;

    private int selectColor = -1;
    private int unSelectColor = -1;

    public FirstLevelCategoryAdapter(@Nullable List<OrderCategoryBean.FoodCategoryTrees> data, Context context) {
        super(R.layout.item_first_level_category, data);
        selectedBg = ContextCompat.getDrawable(context, R.drawable.shape_left_radio_shadow);
        unSelectedBg = ContextCompat.getDrawable(context, R.color.trans);
        selectColor = ContextCompat.getColor(context, R.color.other_order_details_sure_btn_color);
        unSelectColor = ContextCompat.getColor(context, R.color.color_3c);
    }

    @Override
    protected void convert(@NotNull BaseViewHolder viewHolder, OrderCategoryBean.FoodCategoryTrees categoryBean) {
        TextView tvCategoryName = viewHolder.getView(R.id.tv_category_name);
        tvCategoryName.setText(categoryBean.getName());
        CardView view = viewHolder.getView(R.id.layout_category);
        if (categoryBean.getSize() > 0) {
            viewHolder.setText(R.id.tv_category_number, String.valueOf(categoryBean.getSize()));
            viewHolder.setGone(R.id.tv_category_number, false);
        } else {
            viewHolder.setGone(R.id.tv_category_number, true);
        }
        //選中時的背景和文字顏色
        if (viewHolder.getAdapterPosition() == selectedIndex) {
            if (selectedBg != null) {
                view.setBackground(selectedBg);
            }
            if (selectColor != -1) {
                tvCategoryName.setTextColor(selectColor);
            }
            tvCategoryName.setSelected(true);
        } else {
            tvCategoryName.setSelected(false);
            if (unSelectedBg != null) {
                view.setBackground(unSelectedBg);
            }
            if (unSelectColor != -1) {
                tvCategoryName.setTextColor(unSelectColor);
            }
        }
    }

    public FirstLevelCategoryAdapter setSelectedBg(Drawable selectedBg) {
        this.selectedBg = selectedBg;
        return this;
    }

    public FirstLevelCategoryAdapter setUnSelectedBg(Drawable unSelectedBg) {
        this.unSelectedBg = unSelectedBg;
        return this;
    }

    public FirstLevelCategoryAdapter setSelectColor(int selectColor) {
        this.selectColor = selectColor;
        return this;
    }

    public FirstLevelCategoryAdapter setUnSelectColor(int unSelectColor) {
        this.unSelectColor = unSelectColor;
        return this;
    }

    public void setSelectedIndex(int selectedIndex) {
        this.selectedIndex = selectedIndex;
        notifyDataSetChanged();
    }

    public int getSelectedIndex() {
        return selectedIndex;
    }
}
