package com.gingersoft.supply_chain.mvp.ui.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.inputmethod.EditorInfo;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.TextView;

import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.RecyclerView;

import com.billy.cc.core.component.CC;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.common.utils.XPermissionUtils;
import com.gingersoft.gsa.cloud.common.utils.other.TextUtil;
import com.gingersoft.gsa.cloud.common.utils.toast.ToastUtils;
import com.gingersoft.gsa.cloud.component.ComponentName;
import com.gingersoft.gsa.cloud.ui.utils.AppDialog;
import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.R2;
import com.gingersoft.supply_chain.mvp.bean.PurchaseConsumeSnBean;
import com.gingersoft.supply_chain.mvp.bean.PurchaseFoodEncodeSn;
import com.lxj.xpopup.interfaces.OnCancelListener;
import com.qmuiteam.qmui.alpha.QMUIAlphaButton;
import com.qmuiteam.qmui.alpha.QMUIAlphaImageButton;
import com.qmuiteam.qmui.alpha.QMUIAlphaTextView;

import org.jetbrains.annotations.NotNull;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;

import butterknife.BindView;
import butterknife.ButterKnife;
import cn.bingoogolapple.qrcode.core.BarcodeType;
import me.yokeyword.fragmentation.SupportHelper;

/**
 * @author 宇航.
 * User: admin
 * Date: 2021/3/18
 * Time: 17:23
 * Use: 掃描sn碼
 */
public class ScanSnView extends FrameLayout {

    private List<PurchaseFoodEncodeSn> purchaseFoodEncodeSns;
    private ScanSnPopup.OnScanResultListener onScanResultListener;

    @BindView(R2.id.rv_sn_code)
    RecyclerView rvSnCode;
    @BindView(R2.id.btn_confirm_sn)
    QMUIAlphaButton btnFoodIngredientsConfirm;
    @BindView(R2.id.btn_cancel_sn)
    QMUIAlphaButton btnFoodIngredientsCancel;
    @BindView(R2.id.ed_input_sn)
    EditText edInputSn;
    @BindView(R2.id.iv_scan_sn)
    QMUIAlphaImageButton btnScanSn;
    @BindView(R2.id.tv_submit_sn)
    QMUIAlphaTextView tvSubmitSn;
    private Fragment fragment;

    private OnCancelListener onCancelListener;
    private OnSingerResultListener onSingerResultListener;
    /**
     * 初始時snCode的數量，點擊取消時，如果現有的sn數量和剛開始的一樣多，就不提示
     */
    private int initCodeSize = 0;
    /**
     * 新增的sn码数量
     */
    private int newCodeSize = 0;
    private OnDeleteSnCodeListener onDeleteSnCodeListener;
    /**
     * 最大掃碼數量
     */
    private int maxCodeSize = -1;
    /**
     * 最少掃碼數量
     */
    private int minCodeSize = -1;

    public ScanSnView(Fragment fragment, List<PurchaseFoodEncodeSn> purchaseFoodEncodeSns, ScanSnPopup.OnScanResultListener onScanResultListener) {
        super(fragment.requireContext());
        if (purchaseFoodEncodeSns == null) {
            this.purchaseFoodEncodeSns = new ArrayList<>();
        } else {
            this.purchaseFoodEncodeSns = purchaseFoodEncodeSns;
        }
        initCodeSize = this.purchaseFoodEncodeSns.size();
        for (PurchaseFoodEncodeSn purchaseFoodEncodeSn : this.purchaseFoodEncodeSns) {
            if (purchaseFoodEncodeSn.newAdd) {
                newCodeSize++;
            }
        }
        this.onScanResultListener = onScanResultListener;
        this.fragment = fragment;
    }

    public ScanSnView setMaxCodeSize(int maxCodeSize) {
        this.maxCodeSize = maxCodeSize;
        return this;
    }

    public ScanSnView setMinCodeSize(int minCodeSize) {
        this.minCodeSize = minCodeSize;
        return this;
    }

    public ScanSnView init() {
        View rootView = LayoutInflater.from(getContext()).inflate(R.layout.layout_scan_sn, this, false);
        ButterKnife.bind(this, rootView);
        //初始化adapter
        SnCodeAdapter adapter = new SnCodeAdapter(R.layout.item_sn_code, purchaseFoodEncodeSns);
        setConfirmBtnState();
        rvSnCode.setAdapter(adapter);
        //掃描sn媽
        btnScanSn.setOnClickListener(v ->
                XPermissionUtils.launchCamera(fragment, (allGranted, grantedList, deniedList) -> {
                    if (allGranted) {
                        //去掃碼頁面
                        CC.obtainBuilder(ComponentName.COMPONENT_SCAN)
                                .setActionName("openScanActivity")
                                .addParam("scanMode", BarcodeType.ONE_DIMENSION)
                                .build()
                                .callAsyncCallbackOnMainThread((cc, result) -> {
                                    Object qrCodeResult = result.getDataItem("qrCodeResult");
                                    if (qrCodeResult != null) {
                                        String snCode = String.valueOf(qrCodeResult);
                                        if (adapter.getData().contains(snCode)) {
                                            ToastUtils.show(getContext(), "商品已存在，不能重複添加");
                                        } else {
                                            addSnCode(adapter, snCode);
                                        }
                                    }
                                });
                    }
                })
        );
        edInputSn.setOnEditorActionListener((v, actionId, event) -> {
            if (actionId == EditorInfo.IME_ACTION_UNSPECIFIED) {
                //響應回車按鈕
                //隐藏软键盘
                SupportHelper.hideSoftInput(v);
                commitSnCode(adapter);
                setConfirmBtnState();
            }
            return false;
        });
        //提交按鈕
        tvSubmitSn.setOnClickListener(v -> {
            //提交輸入框中的sn碼
            commitSnCode(adapter);
            setConfirmBtnState();
        });

        btnFoodIngredientsConfirm.setOnClickListener(v -> {
            //保存本次掃描的所有sn碼
            //校驗掃描數量和規定的數量是不是一致的，
            onScanResultListener.onScanResult(null, adapter.getData());
        });

        btnFoodIngredientsCancel.setOnClickListener(v -> {
            if (adapter.getData().size() != initCodeSize) {
                AppDialog.getInstance().showWaringDialog(getContext(), "關閉後不會保存SN碼記錄", (view, dialog) -> {
                    dialog.dismiss();
                    onCancelListener.onCancel();
                });
            } else if (onCancelListener != null) {
                onCancelListener.onCancel();
            }
        });
        adapter.setOnItemChildClickListener((adapter1, view, position) -> {
            if (view.getId() == R.id.iv_sn_code_delete) {
                onSingerResultListener.onScanValue(false, adapter.getItem(position), adapter.getItemCount());
                if (onDeleteSnCodeListener != null) {
                    onDeleteSnCodeListener.onDelete(adapter.getItem(position), position);
                }
                if (adapter.getItem(position).newAdd) {
                    newCodeSize--;
                }
                adapter1.removeAt(position);
                setConfirmBtnState();
            }
        });
        addView(rootView);
        return this;
    }

    public void setConfirmBtnState() {
        if (minCodeSize == -1 || newCodeSize == minCodeSize) {
            btnFoodIngredientsConfirm.setBackground(ContextCompat.getDrawable(getContext(), R.drawable.shape_app_btn));
        } else {
            btnFoodIngredientsConfirm.setBackground(ContextCompat.getDrawable(getContext(), R.drawable.shape_btn_unclick));
        }
    }

    private void commitSnCode(SnCodeAdapter adapter) {
        if (TextUtil.isNotEmptyOrNullOrUndefined(edInputSn)) {
            String snCode = edInputSn.getText().toString();
            for (PurchaseFoodEncodeSn datum : adapter.getData()) {
                if (datum.getEncodeSnNo().equals(snCode)) {
                    ToastUtils.show(getContext(), "商品已存在，不能重複添加");
                    return;
                }
            }
            addSnCode(adapter, snCode);
        } else {
            ToastUtils.show(getContext(), "請輸入SN碼");
        }
    }

    /**
     * 添加sn码
     */
    private void addSnCode(SnCodeAdapter adapter, String snCode) {
        PurchaseFoodEncodeSn purchaseFoodEncodeSn = new PurchaseFoodEncodeSn(snCode);
        purchaseFoodEncodeSn.newAdd = true;
        adapter.addData(purchaseFoodEncodeSn);
        newCodeSize++;
        edInputSn.setText("");
        setConfirmBtnState();
        onSingerResultListener.onScanValue(true, purchaseFoodEncodeSn, adapter.getItemCount());
    }

    public ScanSnView setOnCancelListener(OnCancelListener onCancelListener) {
        this.onCancelListener = onCancelListener;
        return this;
    }

    public ScanSnView setOnDeleteSnCodeListener(OnDeleteSnCodeListener onDeleteSnCodeListener) {
        this.onDeleteSnCodeListener = onDeleteSnCodeListener;
        return this;
    }

    public ScanSnView setOnSingerResultListener(OnSingerResultListener onSingerResultListener) {
        this.onSingerResultListener = onSingerResultListener;
        return this;
    }

    public interface OnSingerResultListener {
        /**
         * @param isAdd               true為新增，false為刪除
         * @param snCode              sn碼
         * @param currentSnCodeNumber 當前有多少個sn碼
         */
        void onScanValue(boolean isAdd, PurchaseFoodEncodeSn snCode, int currentSnCodeNumber);
    }

    public interface OnDeleteSnCodeListener {
        void onDelete(PurchaseFoodEncodeSn snCode, int position);
    }

    public interface OnCancelListener {
        void onCancel();
    }

    public static class SnCodeAdapter extends BaseQuickAdapter<PurchaseFoodEncodeSn, BaseViewHolder> {

        public SnCodeAdapter(int layoutResId, @org.jetbrains.annotations.Nullable List<PurchaseFoodEncodeSn> data) {
            super(layoutResId, data);
            addChildClickViewIds(R.id.iv_sn_code_delete);
        }

        @Override
        protected void convert(@NotNull BaseViewHolder viewHolder, PurchaseFoodEncodeSn s) {
            viewHolder.setText(R.id.tv_sn_code, String.valueOf(s.getEncodeSnNo()));
            viewHolder.setTextColor(R.id.tv_sn_code, ContextCompat.getColor(getContext(), R.color.color_3c));
            viewHolder.setTextColor(R.id.tv_serial_number, ContextCompat.getColor(getContext(), R.color.color_3c));
            viewHolder.setGone(R.id.iv_sn_code_delete, false);
            viewHolder.setGone(R.id.it_sn_code_operating, true);
            viewHolder.setText(R.id.tv_serial_number, String.valueOf(viewHolder.getAdapterPosition() + 1));
            if (viewHolder.getAdapterPosition() % 2 == 0) {
                viewHolder.setBackgroundColor(R.id.layout_sn_code, ContextCompat.getColor(getContext(), R.color.color_f9));
            } else {
                viewHolder.setBackgroundColor(R.id.layout_sn_code, ContextCompat.getColor(getContext(), R.color.white));
            }
        }
    }
}
