package com.joe.print.mvp.ui.view;

import android.content.Context;
import android.graphics.Typeface;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.gingersoft.gsa.cloud.database.bean.PrinterDeviceBean;
import com.gingersoft.gsa.cloud.print.bean.base.PrintFoodItem;
import com.joe.print.R;

import java.util.List;

/**
 * @author 宇航.
 * User: admin
 * Date: 2021/1/30
 * Time: 10:40
 * Use:
 */
public class PrintFoodView extends LinearLayout {
    private int foodFontSize = 24;
    private int modifierFontSize = 24;
    private int foodIsBold = 2;
    private int modifierIsBold = 2;
    private int foodIsItalic = 2;
    private int modifierIsItalic = 2;
    private int numberIsFlip = 2;//熱敏打印沒有顏色，翻轉用不了
    private boolean showPrice = true;
    private List<PrintFoodItem> data;

    public PrintFoodView(Context context, List<PrintFoodItem> data, PrinterDeviceBean deviceBean, boolean showPrice) {
        super(context);
        this.showPrice = showPrice;
        this.data = data;
        setOrientation(LinearLayout.VERTICAL);
        init(deviceBean);
    }

    public void init(PrinterDeviceBean deviceBean) {
        try {
            this.foodFontSize = Integer.parseInt(deviceBean.getFoodFont()) * 2;//36
            this.modifierFontSize = Integer.parseInt(deviceBean.getModifierFont()) * 2;
        } catch (NumberFormatException e) {
            e.printStackTrace();
        }
        this.foodIsBold = deviceBean.getFoodIsBold();
        this.modifierIsBold = deviceBean.getModifierIsBold();
        this.foodIsItalic = deviceBean.getFoodIsItalic();
        this.modifierIsItalic = deviceBean.getModifierIsItalic();
        this.numberIsFlip = deviceBean.getNumberIsFlip();
        initView();
    }

    private void initView() {
        for (PrintFoodItem item : data) {
            View view = View.inflate(getContext(), R.layout.print_item_food, null);
            TextView tvFoodName = view.findViewById(R.id.tv_food_name);
            TextView tvNum = view.findViewById(R.id.tv_food_quantity);
            TextView tvPrice = view.findViewById(R.id.tv_food_price);
            if (showPrice) {
                tvPrice.setVisibility(View.VISIBLE);
            } else {
                tvPrice.setVisibility(View.GONE);
            }
            boolean isBold, isItalic;
            if (item.getItemType() == 2) {
                //細項，縮進
                tvFoodName.setText("\u3000" + item.getName());
                tvFoodName.setTextSize(modifierFontSize);
                tvNum.setTextSize(modifierFontSize);
                tvPrice.setTextSize(modifierFontSize);

                isBold = modifierIsBold == 1;
                isItalic = modifierIsItalic == 1;
            } else if (item.getItemType() == 3) {
                //細項，縮進
                tvFoodName.setText("\u3000\u3000" + item.getName());
                tvFoodName.setTextSize(modifierFontSize);
                tvNum.setTextSize(modifierFontSize);
                tvPrice.setTextSize(modifierFontSize);
                isBold = modifierIsBold == 1;
                isItalic = modifierIsItalic == 1;
            } else {
                tvFoodName.setText(item.getName());
                tvFoodName.setTextSize(foodFontSize);
                tvNum.setTextSize(foodFontSize);
                tvPrice.setTextSize(foodFontSize);
                isBold = foodIsBold == 1;
                isItalic = foodIsItalic == 1;
            }

            if (isBold && isItalic) {
                tvFoodName.setTypeface(null, Typeface.BOLD_ITALIC);
                tvNum.setTypeface(null, Typeface.BOLD_ITALIC);
                tvPrice.setTypeface(null, Typeface.BOLD_ITALIC);
            } else if (isBold) {
                tvFoodName.setTypeface(null, Typeface.BOLD);
                tvNum.setTypeface(null, Typeface.BOLD);
                tvPrice.setTypeface(null, Typeface.BOLD);
            } else if (isItalic) {
                tvFoodName.setTypeface(null, Typeface.ITALIC);
                tvNum.setTypeface(null, Typeface.ITALIC);
                tvPrice.setTypeface(null, Typeface.ITALIC);
            } else {
                tvFoodName.setTypeface(null, Typeface.NORMAL);
                tvNum.setTypeface(null, Typeface.NORMAL);
                tvPrice.setTypeface(null, Typeface.NORMAL);
            }
            tvNum.setText("X" + item.getNum());
            tvPrice.setText("$" + item.getPrice());
            addView(view);
        }
    }
}
