package com.gingersoft.supply_chain.mvp.ui.activity;

import android.content.Intent;
import android.os.Bundle;
import android.view.MotionEvent;
import android.view.View;
import android.widget.EditText;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.gingersoft.gsa.cloud.ui.widget.dialog.LoadingDialog;
import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.di.component.DaggerSupplyChainMainComponent;
import com.gingersoft.supply_chain.mvp.content.SupplyShoppingCart;
import com.gingersoft.supply_chain.mvp.contract.SupplyChainMainContract;
import com.gingersoft.supply_chain.mvp.presenter.SupplyChainMainPresenter;
import com.gingersoft.supply_chain.mvp.ui.fragment.FunctionListFragment;
import com.gingersoft.supply_chain.mvp.utils.HideUtil;
import com.jess.arms.base.BaseFragmentActivity;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.utils.ArmsUtils;
import static com.jess.arms.utils.Preconditions.checkNotNull;


/**
 * Description:供應鏈首頁
 */
public class SupplyChainMainActivity extends BaseFragmentActivity<SupplyChainMainPresenter> implements SupplyChainMainContract.View {

    @Override
    public void setupActivityComponent(@NonNull AppComponent appComponent) {
        DaggerSupplyChainMainComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public int initView(@Nullable Bundle savedInstanceState) {
        return R.layout.activity_supply_chain_main;
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
//        HideUtil.init(this);
        loadRootFragment(R.id.layout_supply_chain_content, FunctionListFragment.newInstance());
    }

//    @Override
//    public boolean dispatchTouchEvent(MotionEvent ev) {
//        if (getTopFragment() instanceof NotDispatchListener) {
//            return super.dispatchTouchEvent(ev);
//        }
//        if (ev.getAction() == MotionEvent.ACTION_DOWN) {
//            // 获得当前得到焦点的View，一般情况下就是EditText（特殊情况就是轨迹求或者实体案件会移动焦点）
//            View v = getCurrentFocus();
//            if (v != null && v.getTag() != null && v.getTag() == InfoMultiAdapter.NOT_HIDE_KEYBOARD) {
//                return super.dispatchTouchEvent(ev);
//            }
//            if (isShouldHideInput(v, ev)) {
//                DeviceUtils.hideSoftKeyboard(mContext, v);
//            }
//        }
//        return super.dispatchTouchEvent(ev);
//    }

    /**
     * 根据EditText所在坐标和用户点击的坐标相对比，来判断是否隐藏键盘，因为当用户点击EditText时没必要隐藏
     *
     * @param v
     * @param event
     * @return
     */
    private boolean isShouldHideInput(View v, MotionEvent event) {
        if ((v instanceof EditText)) {
            int[] l = {0, 0};
            v.getLocationInWindow(l);
            int left = l[0], top = l[1], bottom = top + v.getHeight(), right = left
                    + v.getWidth();
            // 点击EditText的事件，忽略它。
            if (event.getX() > left && event.getX() < right
                    && event.getY() > top && event.getY() < bottom) {
                // 点击的是输入框区域，保留点击EditText的事件
                return false;
            } else {
                return true;
            }
        }
        // 如果焦点不是EditText则忽略，这个发生在视图刚绘制完，第一个焦点不在EditView上，和用户用轨迹球选择其他的焦点
        return false;
    }

    @Override
    public void initIntent() {
    }

    @Override
    public void initTopBar() {

    }

    @Override
    public void initLanguage() {

    }

    @Override
    public void initLayoutParams() {

    }

    @Override
    public void initLayoutVisible() {

    }

    @Override
    public void showLoading(String message) {
        if (message != null) {
            LoadingDialog.showDialogForLoading(this, message, true);
        } else {
            LoadingDialog.showDialogForLoading(this);
        }
    }

    @Override
    public void hideLoading() {
        LoadingDialog.cancelDialogForLoading();
    }

    @Override
    public void showMessage(@NonNull String message) {
        ArmsUtils.makeText(this, message);
    }

    @Override
    public void launchActivity(@NonNull Intent intent) {
        checkNotNull(intent);
        ArmsUtils.startActivity(intent);
    }

    @Override
    public void killMyself() {
        finish();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        SupplyShoppingCart.getInstance().clear();
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
    }
}
