package com.gingersoft.gsa.cloud.table.mvp.model.cart;

import com.gingersoft.gsa.cloud.base.common.bean.MemberInfo;
import com.gingersoft.gsa.cloud.base.order.bean.discount.CouponDiscountBean;
import com.gingersoft.gsa.cloud.database.bean.Discount;

import java.util.List;

import io.reactivex.Observable;
import io.reactivex.SingleObserver;
import io.reactivex.disposables.Disposable;
import lombok.Data;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-09-19
 * 修订历史：2020-09-19
 * 描述: 購物車抽象類
 */
@Data
public abstract class ShoppingCart {

    /**
     * 合計
     */
    private double wholeAmount = 0.0;
    /**
     * 總金額
     */
    private double totalAmount = 0.0;


    public static void main(String[] arg) {

        Discount discount = new Discount();
        discount.setType(1);
        discount.setRemark("9折");
        discount.setDiscount_value(10);

        MemberInfo memberDiscount = new MemberInfo();
        memberDiscount.setMemberName("斯八達");
        memberDiscount.setMemberDiscount(20);

        CouponDiscountBean couponDiscount = new CouponDiscountBean();
        couponDiscount.setCouponType((byte) 2);
        couponDiscount.setCouponTypeName1("立減8元");
        couponDiscount.setAmount(8);

//        NomalDiscount nomalDiscountBean = (NomalDiscount) shoppingCart.addNomalDiscount(discount);
//        MemberDiscount memberDiscountBean = (MemberDiscount) shoppingCart.addMemberDiscount(memberDiscount);
//        CouponDiscount couponDiscountBean = (CouponDiscount) shoppingCart.addCouponDiscount(couponDiscount);
//
//        MultyDiscount multyDiscount = shoppingCart.getMultyDiscounts();
//        double money = multyDiscount.calculate(100);
//
//        System.out.println("calculate : " + money);
//        System.out.println("NomalDiscount discountMoney : " + nomalDiscountBean.getDiscountMoney());
//        System.out.println("MemberDiscount discountMoney : " + memberDiscountBean.getDiscountMoney());
//        System.out.println("CouponDiscount discountMoney : " + couponDiscountBean.getDiscountMoney());

        String[] strs = new String[]{"jack", "ann", "one", "two", "three", "four"};
        Observable.fromArray(strs)
                .toSortedList()//自然排序 ，升序
                .subscribe(new SingleObserver<List<String>>() {
                    @Override
                    public void onSubscribe(Disposable d) {

                    }

                    @Override
                    public void onSuccess(List<String> list) {
                        if (list != null) {
                            for (int i = 0; i < list.size(); i++) {
                                System.out.println("toList item======="
                                        + list.get(i));
                            }
                        }
                    }

                    @Override
                    public void onError(Throwable e) {

                    }
                });
    }


    /**
     * 具體支付類需要實現的方法
     */
    public void pay(double money) {

    }
}
