package com.joe.print.mvp.print;

import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.widget.LinearLayout;
import com.gingersoft.gsa.cloud.common.constans.AppConstans;
import com.gingersoft.gsa.cloud.common.constans.ExpandConstant;
import com.gingersoft.gsa.cloud.common.core.delivery.OrderDetails;
import com.gingersoft.gsa.cloud.common.core.member.MemberInfo;
import com.gingersoft.gsa.cloud.common.core.restaurant.utils.RestaurantExpandInfoUtils;
import com.gingersoft.gsa.cloud.common.core.table.TableBean;
import com.gingersoft.gsa.cloud.common.utils.other.TextUtil;
import com.gingersoft.gsa.cloud.common.utils.time.TimeUtils;
import com.gingersoft.gsa.cloud.database.bean.PrinterDeviceBean;
import com.gingersoft.gsa.cloud.order.billItem.BillItem;
import com.gingersoft.gsa.cloud.order.cart.ShoppingCart;
import com.gingersoft.gsa.cloud.order.commodity.OrderDetail;
import com.gingersoft.gsa.cloud.order.order.DoshokuOrder;
import com.gingersoft.gsa.cloud.print.bean.PrintBillContent;
import com.gingersoft.gsa.cloud.print.bean.base.PrintBillItem;
import com.gingersoft.gsa.cloud.print.bean.base.PrintFoodItem;
import com.joe.print.mvp.model.bean.BillingBean;
import com.joe.print.mvp.model.bean.HtmlLable;
import com.joe.print.mvp.print.common.HtmlContract;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static com.joe.print.mvp.print.common.HtmlContract.LABLE_COLUMN;
import static com.joe.print.mvp.print.common.HtmlContract.LABLE_DIV;
import static com.joe.print.mvp.print.common.HtmlContract.LABLE_P;
import static com.joe.print.mvp.print.common.HtmlContract.LABLE_QRCODE;

/**
 * 結賬單  已改新版
 */
public class PrintBill extends PrinterRoot<PrintBillContent> {


    private PrintBillContent mPrintBillContent;

    @Override
    protected void setPrintContent(PrintBillContent printContent) {
        this.mPrintBillContent = printContent;
    }

    @Override
    public Map<String, List<Bitmap>> getPrintBitmap(Context mContext, PrinterDeviceBean deviceBean) {
        Map<String, List<Bitmap>> bitmapMaps = new HashMap<>();
        List<Bitmap> bitmaps = new ArrayList<>();
        bitmaps.add(getBitmap(mContext, deviceBean));
        bitmapMaps.put("", bitmaps);
        return bitmapMaps;
    }

    @Override
    public String[] getPrintDatas(Context mContext, PrinterDeviceBean deviceBean) {

        if (mPrintBillContent == null) {
            return new String[]{"<html><body></body></html>"};
        }

        String stringBuilder = "<html><body>" +
                getHtmlContent(deviceBean) +
                "</body></html>";

        int printCount = getPrintCount(mContext);
        String[] pritContent = new String[printCount];
        for (int i = 0; i < printCount; i++) {
            pritContent[i] = stringBuilder;
        }
        return pritContent;
    }

    private String getHtmlContent(PrinterDeviceBean deviceBean) {

        List<HtmlLable> htmlLables = new ArrayList<>();

        /**
         * 頭部
         */
        htmlLables.add(new HtmlLable(LABLE_DIV, mPrintBillContent.getBrand(),
                new HtmlLable.Attributes(HtmlContract.ATTRIBUTES_ALIGN, HtmlContract.value_align_center, HtmlContract.value_type_string),
                new HtmlLable.Attributes(HtmlContract.ATTRIBUTES_FONT_SIZE, "28")));
        htmlLables.add(new HtmlLable(LABLE_DIV, mPrintBillContent.getResturantName(),
                new HtmlLable.Attributes(HtmlContract.ATTRIBUTES_ALIGN, HtmlContract.value_align_center, HtmlContract.value_type_string),
                new HtmlLable.Attributes(HtmlContract.ATTRIBUTES_FONT_SIZE, "28")));
        htmlLables.add(new HtmlLable(LABLE_P, HtmlContract.dividing_line));
        /**
         * 訂單
         */
        String orderNum = "單號：";
        if (TextUtil.isNotEmptyOrNullOrUndefined(DoshokuOrder.getInstance().getOrderNo())) {
            orderNum = "單號：" + DoshokuOrder.getInstance().getOrderNo();
        }
        htmlLables.addAll(getRowInformation(new HtmlLable[]{new HtmlLable(LABLE_COLUMN, "餐檯：" + mPrintBillContent.getTableName())}, 24));
        htmlLables.addAll(getRowInformation(new HtmlLable[]{new HtmlLable(LABLE_COLUMN, "人數：" + mPrintBillContent.getPerson())}, 24));
        htmlLables.addAll(getRowInformation(new HtmlLable[]{new HtmlLable(LABLE_COLUMN, orderNum)}, 24));
        htmlLables.addAll(getRowInformation(new HtmlLable[]{new HtmlLable(LABLE_COLUMN, "日期：" + TimeUtils.parseTimeRepeat(mPrintBillContent.getCreateTime(), TimeUtils.DEFAULT_DATE_FORMAT))}, 24));
        htmlLables.add(new HtmlLable(LABLE_P, HtmlContract.dividing_line));
        /**
         * 食品
         */
        if (mPrintBillContent.getFoodItemList() != null && mPrintBillContent.getFoodItemList().size() > 0) {
            htmlLables.addAll(getBBPosFoodLineString(mPrintBillContent.getFoodItemList(), deviceBean));
            htmlLables.add(new HtmlLable(LABLE_P, HtmlContract.dividing_line));
        }
        /**
         * 合計、賬單項、總金額、支付方式
         */
        //合計
        htmlLables.addAll(getRowInformation(new HtmlLable[]{
                new HtmlLable(LABLE_COLUMN, "合計:"),
                new HtmlLable(LABLE_COLUMN, AppConstans.CARSH_STR + mPrintBillContent.getWholeAmount(), new HtmlLable.Attributes(HtmlContract.ATTRIBUTES_OFFSET, HtmlContract.value_offset_last))}, 28));

        List<PrintBillItem> billItemList = mPrintBillContent.getBillItemList();
        if (billItemList.size() > 0) {
            for (PrintBillItem billItem : billItemList) {
                htmlLables.addAll(getRowInformation(new HtmlLable[]{
                        new HtmlLable(LABLE_COLUMN, billItem.getBillName()),
                        new HtmlLable(LABLE_COLUMN, billItem.getBillAmount(), new HtmlLable.Attributes(HtmlContract.ATTRIBUTES_OFFSET, HtmlContract.value_offset_last))}, 28));
            }
            htmlLables.add(new HtmlLable(LABLE_P, HtmlContract.dividing_line));
        }
        //總金額
        htmlLables.addAll(getRowInformation(new HtmlLable[]{
                new HtmlLable(LABLE_COLUMN, "總金額:"),
                new HtmlLable(LABLE_COLUMN, AppConstans.CARSH_STR + mPrintBillContent.getTotalAmount(), new HtmlLable.Attributes(HtmlContract.ATTRIBUTES_OFFSET, HtmlContract.value_offset_last))}, 35));

        htmlLables.add(new HtmlLable(LABLE_P, HtmlContract.dividing_line));
        //支付方式
        List<PrintBillItem> payMethodItemList = mPrintBillContent.getPayMethodItemList();
        if (payMethodItemList.size() > 0) {
            for (PrintBillItem billItem : payMethodItemList) {
                htmlLables.addAll(getRowInformation(new HtmlLable[]{
                        new HtmlLable(LABLE_COLUMN, billItem.getBillName()),
                        new HtmlLable(LABLE_COLUMN, billItem.getBillAmount(), new HtmlLable.Attributes(HtmlContract.ATTRIBUTES_OFFSET, HtmlContract.value_offset_last))}, 28));
            }
            htmlLables.add(new HtmlLable(LABLE_P, HtmlContract.dividing_line));
        }

        /**
         * 會員積分
         */
        if (mPrintBillContent.getAddPoints() != 0 || mPrintBillContent.getOldPoints() != 0 || mPrintBillContent.getNowPoints() != 0) {
            List<String> items = new ArrayList<>();
            items.add("本次積分: " + mPrintBillContent.getAddPoints());
            items.add("上次積分: " + mPrintBillContent.getOldPoints());
            items.add("結餘積分: " + mPrintBillContent.getNowPoints());
            items.add("會員名稱: " + mPrintBillContent.getMemberName());
            items.add("會員電話: " + mPrintBillContent.getPhone());
            for (String item : items) {
                htmlLables.addAll(getRowInformation(new HtmlLable[]{new HtmlLable(LABLE_COLUMN, item)}, 24));
            }
        }
        //qrcode
        if ((boolean) RestaurantExpandInfoUtils.getValue(ExpandConstant.ToPrintQRCode, false) == true &&
                !TextUtils.isEmpty(mPrintBillContent.getIntegralQrCode())) {
            htmlLables.add(new HtmlLable(LABLE_DIV, mPrintBillContent.getIntegralHead(),
                    new HtmlLable.Attributes(HtmlContract.ATTRIBUTES_ALIGN, HtmlContract.value_align_center, HtmlContract.value_type_string),
                    new HtmlLable.Attributes(HtmlContract.ATTRIBUTES_FONT_SIZE, "24")));
            htmlLables.add(new HtmlLable(LABLE_QRCODE, mPrintBillContent.getIntegralQrCode(),
                    new HtmlLable.Attributes(HtmlContract.ATTRIBUTES_SCALE, HtmlContract.value_scale_1, HtmlContract.value_type_string)));
            htmlLables.add(new HtmlLable(LABLE_DIV, mPrintBillContent.getIntegralFoot(),
                    new HtmlLable.Attributes(HtmlContract.ATTRIBUTES_ALIGN, HtmlContract.value_align_center, HtmlContract.value_type_string),
                    new HtmlLable.Attributes(HtmlContract.ATTRIBUTES_FONT_SIZE, "24")));
        }
        /**
         * 底部
         */
        htmlLables.add(new HtmlLable(LABLE_DIV, mPrintBillContent.getPoliteLanguage(),
                new HtmlLable.Attributes(HtmlContract.ATTRIBUTES_ALIGN, HtmlContract.value_align_center, HtmlContract.value_type_string),
                new HtmlLable.Attributes(HtmlContract.ATTRIBUTES_FONT_SIZE, "24")));

        htmlLables.add(new HtmlLable(LABLE_DIV, TimeUtils.getCurrentTimeInString(TimeUtils.DEFAULT_DATE_FORMAT),
                new HtmlLable.Attributes(HtmlContract.ATTRIBUTES_ALIGN, HtmlContract.value_align_center, HtmlContract.value_type_string),
                new HtmlLable.Attributes(HtmlContract.ATTRIBUTES_FONT_SIZE, "24")));

        return getHtmlLables(htmlLables.toArray(new HtmlLable[htmlLables.size()]));
    }

    @Override
    public int getPrintCount(Context context) {
        return RestaurantExpandInfoUtils.getValue(ExpandConstant.TableModeClosingPC, 1);
    }

    private Bitmap getBitmap(Context mContext, PrinterDeviceBean deviceBean) {

        LinearLayout layout = new LinearLayout(mContext);
        layout.setOrientation(LinearLayout.VERTICAL);

        //訂單頭
        layout.addView(getHeader(mContext));
        layout.addView(getLine(mContext));

        //訂單信息
        String tableName = "餐檯：" + mPrintBillContent.getTableName();
        String peopleNum = "人數：" + mPrintBillContent.getPerson();
        String orderNum = "單號：";
        if (TextUtil.isNotEmptyOrNullOrUndefined(mPrintBillContent.getOrderNo())) {
            orderNum = "單號：" + mPrintBillContent.getOrderNo();
        }
        String createTime = "日期：" + TimeUtils.parseTimeRepeat(mPrintBillContent.getCreateTime(), TimeUtils.DEFAULT_DATE_FORMAT);
        layout.addView(getDiningTableOrderInfo(mContext, tableName, peopleNum, orderNum, createTime));
        layout.addView(getLine(mContext));

        //食品信息
        layout.addView(getDiningFoodList(mContext, mPrintBillContent.getFoodItemList(), deviceBean, 1, true));
        layout.addView(getHalfLine(mContext));

        //訂單金額信息
        List<BillingBean> billingBeans = new ArrayList<>();
        //添加合計項
        billingBeans.add(new BillingBean("合計", mPrintBillContent.getWholeAmount()));
        //添加其他金額項
        if (mPrintBillContent.getBillItemList().size() > 0) {
            for (PrintBillItem item : mPrintBillContent.getBillItemList()) {
                billingBeans.add(new BillingBean(item.getBillName(), Double.parseDouble(item.getBillAmount())));
            }
        }
        layout.addView(getDiningBillInfo(mContext, billingBeans));
        layout.addView(getHalfLine(mContext));

//        BigDecimal totalAmount = new BigDecimal(0);
//        for (OrderDetail OrderDetail : MyOrderManage.getInstance().getOrderFoodList()) {
//            totalAmount = MoneyUtil.sum(totalAmount, OrderDetail.getPrice());
//        }
        layout.addView(getAmountText(mContext, "總金額：" + mPrintBillContent.getTotalAmount()));
        layout.addView(getLine(mContext));
        layout.addView(getDiningBillPayMethod(mContext, mPrintBillContent.getPayMethodItemList()));
        layout.addView(getLine(mContext));

        layout.addView(getTableMealMemberIntegerView(mContext, getOrderMemberInfo(), mPrintBillContent.getIntegralQrCode()));

        return zoomBitmap(deviceBean, viewToBitmap(mContext, layout));
    }


    private OrderDetails.DataBean getOrderMemberInfo() {
        OrderDetails.DataBean dataBean = new OrderDetails.DataBean();
        MemberInfo memberInfo = DoshokuOrder.getInstance().getMemberInfo();
        if (memberInfo != null) {
            dataBean.setMEMBER_NAME(memberInfo.getMemberName());
            dataBean.setPHONE(memberInfo.getPhone());
            dataBean.setNowPoints(DoshokuOrder.getInstance().getNowPoints());
            dataBean.setAddPoints(DoshokuOrder.getInstance().getAddPoints());
            dataBean.setOldPoints(DoshokuOrder.getInstance().getOldPoints());
        }
        return dataBean;
    }

}
