package com.gingersoft.supply_chain.mvp.ui.adapter;

import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import android.widget.EditText;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.common.utils.other.TextUtil;
import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.mvp.bean.BasicUnitBean;
import com.gingersoft.supply_chain.mvp.bean.DeputyUnitBean;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/12/29
 * Time: 16:31
 * Use:
 */
public class DeputyUnitAdapter extends BaseQuickAdapter<DeputyUnitBean, BaseViewHolder> {

    public DeputyUnitAdapter(@Nullable List<DeputyUnitBean> data) {
        super(R.layout.item_deputy_unit, data);
        addChildClickViewIds(R.id.iv_deputy_unit_delete);
    }

    @Override
    protected void convert(@NotNull BaseViewHolder viewHolder, DeputyUnitBean item) {
        EditText edDeputyUnitName = viewHolder.getView(R.id.ed_deputy_unit_name);
        EditText edConversionMultiple = viewHolder.getView(R.id.ed_deputy_unit_conversion_multiple);
        viewHolder.setText(R.id.tv_deputy_unit_title, "副單位" + (viewHolder.getAdapterPosition() + 1));
        viewHolder.setText(R.id.ed_deputy_unit_name, item.getDeputyUnit());
        viewHolder.setText(R.id.ed_deputy_unit_conversion_multiple, item.getConversionMultiple());
        if (TextUtil.isEmptyOrNullOrUndefined(item.getDeputyUnit())) {
            edDeputyUnitName.requestFocus();
        }
        TextWatcher deputyUnitNameWatcher = new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {

            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {

            }

            @Override
            public void afterTextChanged(Editable s) {
                DeputyUnitBean deputyUnitBean = getData().get(viewHolder.getAdapterPosition());
                deputyUnitBean.setDeputyUnit(s + "");
            }
        };
        setFocusChangeListener(edDeputyUnitName, deputyUnitNameWatcher);
        TextWatcher conversionMultipleWatcher = new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {

            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {

            }

            @Override
            public void afterTextChanged(Editable s) {
                DeputyUnitBean deputyUnitBean = getData().get(viewHolder.getAdapterPosition());
                deputyUnitBean.setConversionMultiple(s + "");
            }
        };
        setFocusChangeListener(edConversionMultiple, conversionMultipleWatcher);
    }

    private void setFocusChangeListener(EditText edDeputyUnitName, TextWatcher deputyUnitNameWatcher) {
        edDeputyUnitName.setOnFocusChangeListener((v, hasFocus) -> {
            if (hasFocus) {
                edDeputyUnitName.addTextChangedListener(deputyUnitNameWatcher);
            } else {
                edDeputyUnitName.removeTextChangedListener(deputyUnitNameWatcher);
            }
        });
    }
}
