package com.gingersoft.gsa.cloud.table.mvp.ui.adapter.meal;

import android.content.Context;
import android.graphics.drawable.GradientDrawable;
import android.text.TextUtils;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.gingersoft.gsa.cloud.app.GsaCloudApplication;
import com.gingersoft.gsa.cloud.database.bean.ComboItem;
import com.gingersoft.gsa.cloud.database.bean.Modifier;
import com.gingersoft.gsa.cloud.table.R;
import com.gingersoft.gsa.cloud.table.R2;
import com.gingersoft.gsa.cloud.ui.view.BeveLabelView;
import com.jess.arms.base.BaseHolder;
import com.jess.arms.base.DefaultAdapter;
import com.jess.arms.utils.ArmsUtils;
import com.jess.arms.utils.DeviceUtils;

import java.util.List;

import butterknife.BindView;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2018/6/27
 * 修订历史：2018/6/27
 * 描述：
 */

public class ComboAdapter extends DefaultAdapter<ComboItem> {

    private Context mContext;

    private int ColWidth;
    private int ColHeight;
    private int FontSize;

    private int soldoutModFlagHeight;
    private int soldoutFoodFlagFontSize;


    public ComboAdapter(Context context, List<ComboItem> infos) {
        super(infos);
        this.mContext = context;

        int ComboColCount = 4;
        int screenWidth = (int) DeviceUtils.getScreenWidth(context);
        ColWidth = ((screenWidth - ComboColCount) / ComboColCount);
        ColHeight = GsaCloudApplication.uiStyleConfiguration.getModBtnHeightValue();
        FontSize = GsaCloudApplication.uiStyleConfiguration.getModFontSizeValue();
        soldoutModFlagHeight = GsaCloudApplication.uiStyleConfiguration.getSoldoutModFlagHeightValue();
        soldoutFoodFlagFontSize = GsaCloudApplication.uiStyleConfiguration.getSoldoutFoodFlagFontSizeValue();
    }

    @Override
    public int getItemCount() {
        return mInfos.size();
    }

    @Override
    public BaseHolder<ComboItem> getHolder(View v, int viewType) {
        return new ComboItemHolder(v);
    }

    @Override
    public int getLayoutId(int viewType) {
        return R.layout.meal_item_combo;
    }

    class ComboItemHolder extends BaseHolder<ComboItem> {

        @BindView(R2.id.tv_name)
        TextView tv_name;
        @BindView(R2.id.tv_soldout)
        TextView tv_soldout;

        @BindView(R2.id.iv_qty_sold)
        ImageView iv_qty_sold;
        @BindView(R2.id.iv_return)
        ImageView iv_return;
        @BindView(R2.id.blv_soldout)
        BeveLabelView blv_soldout;

        public ComboItemHolder(View itemView) {
            super(itemView);
        }

        @Override
        public void setData(ComboItem datasBean, int position) {

            iv_qty_sold.setVisibility(View.INVISIBLE);
            tv_soldout.setVisibility(View.INVISIBLE);

            if (!datasBean.isModifier()) {
                initComboName(datasBean);
            } else {
                initModifierName(datasBean.getModifier());
                initModifierSoldout(datasBean.getModifier());
            }
            setSolodStatus(datasBean);
            initComboLayoutParams();

            tv_name.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    if (mOnItemClickListener != null) {
                        mOnItemClickListener.onItemClick(datasBean, position);
                    }
                }
            });
        }

        private void initModifierName(Modifier datasBean) {
            String desc = datasBean.getModifierName();
//            switch (GSAApplication.androidSetting.getDataLanguage()) {
//                case 1:
//                    desc = datasBean.getDesc1();
//                    break;
//                case 2:
//                    desc = datasBean.getDesc2();
//                    break;
//                case 3:
//                    desc = datasBean.getDesc3();
//                    break;
//            }
//            if (desc == null || desc.trim().length() == 0) {
//                desc = datasBean.getDesc1();
//            }
            tv_name.setText(desc);

//            com.elegant.bin.gsa.mvp.main.model.bean.Color.DatasBean bgAndFontColor = datasBean.getBgAndFontColor();
//            if (bgAndFontColor != null) {
//                if (!TextUtils.isEmpty(bgAndFontColor.getAndroidColor())) {
//                    tv_name.setBackgroundColor(Color.parseColor(bgAndFontColor.getAndroidColor()));
//                } else {
            tv_name.setBackgroundColor(ArmsUtils.getColor(mContext, R.color.keyboard_paybill_normal));
//                }
//                if (!TextUtils.isEmpty(bgAndFontColor.getAndroidfontcolor())) {
//                    tv_name.setTextColor(Color.parseColor(bgAndFontColor.getAndroidfontcolor()));
//                } else {
            tv_name.setTextColor(ArmsUtils.getColor(mContext, R.color.theme_white_color));
//                }
//            }

//            tv_name.setHeight(ColHeight);
//            tv_name.setWidth(ColWidth);
//            tv_name.setMaxWidth(ColHeight);
//            tv_name.setMinWidth(ColWidth);
            tv_name.setGravity(Gravity.CENTER);

            tv_name.setTextSize(FontSize);
        }

        private void initModifierSoldout(Modifier datasBean) {
            String qty = datasBean.getCurrentMaxNumber();
            if (TextUtils.isEmpty(qty)) {
                tv_soldout.setVisibility(View.INVISIBLE);
            } else {
                if (qty.equalsIgnoreCase("售罄")) {
                    iv_qty_sold.setVisibility(View.VISIBLE);
                } else {
                    tv_soldout.setVisibility(View.VISIBLE);
                    tv_soldout.setText(qty);
                }
            }
        }

        private void initComboName(ComboItem datasBean) {
            String Fname = datasBean.getName();
            tv_name.setText(Fname);
            tv_name.setTextSize(FontSize);

            initComboColor(datasBean);
        }

        private void setSolodStatus(ComboItem datasBean) {

            tv_soldout.setMinHeight(soldoutModFlagHeight);
            tv_soldout.setTextSize(soldoutFoodFlagFontSize);
            tv_soldout.setBackgroundDrawable(mContext.getResources().getDrawable(R.drawable.meal_shape_remaining_number_bg));
            tv_soldout.setGravity(Gravity.CENTER);

            RelativeLayout.LayoutParams lp2 = new RelativeLayout.LayoutParams(new ViewGroup.MarginLayoutParams(60, 40));
            lp2.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
            lp2.addRule(RelativeLayout.ALIGN_PARENT_LEFT);
            tv_soldout.setLayoutParams(lp2);

            tv_soldout.setVisibility(View.INVISIBLE);
            iv_qty_sold.setVisibility(View.INVISIBLE);
            blv_soldout.setVisibility(View.INVISIBLE);

            String qty = datasBean.getCurrentMaxNumber();
            if (TextUtils.isEmpty(qty)) {
                tv_soldout.setVisibility(View.INVISIBLE);
            } else {
                if (qty.equalsIgnoreCase("售罄") || qty.equalsIgnoreCase("暫停") ) {
                    blv_soldout.setLableText(qty);
                    blv_soldout.setVisibility(View.VISIBLE);
                } else {
                    tv_soldout.setVisibility(View.VISIBLE);
                    tv_soldout.setText(qty);
                }
            }
        }

        private void initComboColor(ComboItem datasBean) {
            GradientDrawable drawable = new GradientDrawable();
            drawable.setShape(GradientDrawable.RECTANGLE);
            drawable.setGradientType(GradientDrawable.RECTANGLE);
            drawable.setCornerRadius(5);
            drawable.setColor(datasBean.getBgColor());

            tv_name.setBackground(drawable);
            tv_name.setTextColor(datasBean.getFontColor());
        }

        private void initComboLayoutParams() {
            ViewGroup.LayoutParams layoutParams = tv_name.getLayoutParams();
            //这里减2 减去分割线宽度
//            layoutParams.width = ColWidth - 4;
            layoutParams.height = ColHeight;
            tv_name.setLayoutParams(layoutParams);
        }
    }

    private OnItemClickListener mOnItemClickListener;

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        mOnItemClickListener = onItemClickListener;
    }

    public interface OnItemClickListener {

        void onItemClick(ComboItem datasBean, int position);

    }
}
