package com.gingersoft.gsa.cloud.pay.pos.hywebpos.bean.response.pos;

import android.os.Parcel;
import android.os.Parcelable;

import lombok.Data;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2019-11-07
 * 修订历史：2019-11-07
 * 描述：
 */
@Data
public class RetrievalRespose  extends HywebPosResponse implements Parcelable {

    /**
     * SALE/REFUND/PREAUTH/OFFLINE
     */
    private String TXN_TYPE;
//    private String TXN_ID;

    /**
     * 仅当STATUS = 00时才返回以下字段
     * TXN_STATUS:V 訂單已取消
     */
    private String TXN_STATUS ;
//    private String TXN_AMT ;
//    private double TIPS  ;
    private String PAYMENT_TYPE ;
    private String RESP_CODE;
    private String LOYALTY_TYPE;
    private String CAMPAIGN_ID;
    private String TRACE_NO;
    private String TXN_DATE;
    private String TXN_TIME;
    private String HOST_REF;
    private String COUPON_ID;
    private String AUTH_CODE;
    private int TENDER ;
    private double AUTH_AMT;
    private double DISCOUNT ;
    private String LOCAL_CUR;
    private String FOREIGN_CUR;
    private double FXRATE ;
    private double FOREIGN_AMT;
    private String MID ;
    private String TID ;
    private String PAN  ;
    private String EXPIRY_DATE ;


    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeString(this.TXN_TYPE);
        dest.writeString(this.TXN_STATUS);
        dest.writeString(this.PAYMENT_TYPE);
        dest.writeString(this.RESP_CODE);
        dest.writeString(this.LOYALTY_TYPE);
        dest.writeString(this.CAMPAIGN_ID);
        dest.writeString(this.TRACE_NO);
        dest.writeString(this.TXN_DATE);
        dest.writeString(this.TXN_TIME);
        dest.writeString(this.HOST_REF);
        dest.writeString(this.COUPON_ID);
        dest.writeString(this.AUTH_CODE);
        dest.writeInt(this.TENDER);
        dest.writeDouble(this.AUTH_AMT);
        dest.writeDouble(this.DISCOUNT);
        dest.writeString(this.LOCAL_CUR);
        dest.writeString(this.FOREIGN_CUR);
        dest.writeDouble(this.FXRATE);
        dest.writeDouble(this.FOREIGN_AMT);
        dest.writeString(this.MID);
        dest.writeString(this.TID);
        dest.writeString(this.PAN);
        dest.writeString(this.EXPIRY_DATE);
    }

    protected RetrievalRespose(Parcel in) {
        super(in);
        this.TXN_TYPE = in.readString();
        this.TXN_STATUS = in.readString();
        this.PAYMENT_TYPE = in.readString();
        this.RESP_CODE = in.readString();
        this.LOYALTY_TYPE = in.readString();
        this.CAMPAIGN_ID = in.readString();
        this.TRACE_NO = in.readString();
        this.TXN_DATE = in.readString();
        this.TXN_TIME = in.readString();
        this.HOST_REF = in.readString();
        this.COUPON_ID = in.readString();
        this.AUTH_CODE = in.readString();
        this.TENDER = in.readInt();
        this.AUTH_AMT = in.readDouble();
        this.DISCOUNT = in.readDouble();
        this.LOCAL_CUR = in.readString();
        this.FOREIGN_CUR = in.readString();
        this.FXRATE = in.readDouble();
        this.FOREIGN_AMT = in.readDouble();
        this.MID = in.readString();
        this.TID = in.readString();
        this.PAN = in.readString();
        this.EXPIRY_DATE = in.readString();
    }

    public static final Creator<RetrievalRespose> CREATOR = new Creator<RetrievalRespose>() {
        @Override
        public RetrievalRespose createFromParcel(Parcel source) {
            return new RetrievalRespose(source);
        }

        @Override
        public RetrievalRespose[] newArray(int size) {
            return new RetrievalRespose[size];
        }
    };
}
