package com.gingersoft.gsa.cloud.common.ui.adapter;

import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;

import com.gingersoft.gsa.cloud.common.R;
import com.gingersoft.gsa.cloud.common.R2;
import com.gingersoft.gsa.cloud.common.ui.bean.view.SectionHeader;
import com.gingersoft.gsa.cloud.common.ui.bean.view.SectionRestaurantItem;
import com.gingersoft.gsa.cloud.common.ui.view.section.QDSectionHeaderView;
import com.qmuiteam.qmui.widget.section.QMUIDefaultStickySectionAdapter;
import com.qmuiteam.qmui.widget.section.QMUISection;
import com.qmuiteam.qmui.widget.section.QMUIStickySectionAdapter;

import butterknife.BindView;
import butterknife.ButterKnife;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-02-09
 * 修订历史：2020-02-09
 * 描述：
 */
public class BasTextSectiontAdapter extends QMUIDefaultStickySectionAdapter<SectionHeader, SectionRestaurantItem> {

    @NonNull
    @Override
    protected QMUIStickySectionAdapter.ViewHolder onCreateSectionHeaderViewHolder(@NonNull ViewGroup viewGroup) {
        return new QMUIStickySectionAdapter.ViewHolder(new QDSectionHeaderView(viewGroup.getContext()));
    }

    @NonNull
    @Override
    protected ViewHolder onCreateSectionItemViewHolder(@NonNull ViewGroup viewGroup) {
        return new ViewHolder(View.inflate(viewGroup.getContext(), R.layout.iu_item_base_text_section, null));
    }

    @Override
    protected void onBindSectionHeader(QMUIStickySectionAdapter.ViewHolder holder, int position, QMUISection<SectionHeader, SectionRestaurantItem> section) {
        super.onBindSectionHeader(holder, position, section);
        QDSectionHeaderView itemView = (QDSectionHeaderView) holder.itemView;
        itemView.render(section.getHeader(), section.isFold());
        itemView.getArrowView().setOnClickListener(v -> {
            int pos = holder.isForStickyHeader ? position : holder.getAdapterPosition();
            toggleFold(pos, false);
        });
    }

    @Override
    protected void onBindSectionItem(QMUIStickySectionAdapter.ViewHolder holder, int position, QMUISection<SectionHeader, SectionRestaurantItem> section, int itemIndex) {
        super.onBindSectionItem(holder, position, section, itemIndex);
        ViewHolder viewHolder = (ViewHolder) holder;
        viewHolder.tv_name.setText(section.getItemAt(itemIndex).getRestaurantsBean().getRestaurantName());
    }

    public class ViewHolder extends QMUIStickySectionAdapter.ViewHolder {
        @BindView(R2.id.tv_name)
        TextView tv_name;//功能名

        public ViewHolder(View itemView) {
            super(itemView);
            ButterKnife.bind(this, itemView);
        }

        public TextView getTvName() {
            return tv_name;
        }

        public SectionRestaurantItem getSectionRestaurantItem(int position) {
            SectionRestaurantItem item = getSectionItem(position);
            return item;
        }
    }

}
