package com.gingersoft.gsa.cloud.common.ui.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.util.AttributeSet;
import android.view.animation.AnimationUtils;

import com.gingersoft.gsa.cloud.common.R;
import com.qmuiteam.qmui.alpha.QMUIAlphaImageButton;

public class TriangleView extends QMUIAlphaImageButton {
    private static final int TOP = 0;
    private static final int BOTTOM = 1;
    private static final int RIGHT = 2;
    private static final int LEFT = 3;

    private Paint mPaint;
    private Path path;
    //三角形朝向
    private int direction;

    private int color;

    private boolean isOpen;
    public TriangleView(Context context) {
        this(context, null);
    }

    public TriangleView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TriangleView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.TriangleView, 0, 0);
        color = typedArray.getColor(R.styleable.TriangleView_trv_color, context.getResources().getColor(R.color.color_c8));
        direction = typedArray.getInt(R.styleable.TriangleView_trv_direction, TOP);
        typedArray.recycle();
        init();
    }

    //初始化畫筆
    private void init() {
        mPaint = new Paint();
        //設置抗鋸齒
        mPaint.setAntiAlias(true);
        mPaint.setStyle(Paint.Style.FILL);
        mPaint.setColor(color);
        path = new Path();
    }


    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        switch (direction) {
            case TOP:
                path.moveTo(0, getHeight());
                path.lineTo(getWidth(), getHeight());
                path.lineTo(getWidth() / 2, 0);
                break;
            case BOTTOM:
                path.moveTo(0, 0);
                path.lineTo(getWidth() / 2, getHeight());
                path.lineTo(getWidth(), 0);
                break;
            case RIGHT:
                path.moveTo(0, 0);
                path.lineTo(0, getHeight());
                path.lineTo(getWidth(), getHeight() / 2);
                break;
            case LEFT:
                path.moveTo(0, getHeight() / 2);
                path.lineTo(getWidth(), getHeight());
                path.lineTo(getWidth(), 0);
                break;
        }
        path.close();
        canvas.drawPath(path, mPaint);
    }

    public boolean isOpen() {
        return isOpen;
    }

    public void setOpen(boolean open) {
        isOpen = open;
    }

    public void toggle(){
        if(isOpen){
            startAnimation(AnimationUtils.loadAnimation(getContext(), R.anim.rotate_anticlockwise_anim));
        } else {
            startAnimation(AnimationUtils.loadAnimation(getContext(), R.anim.rotate_clockwise_anim));
        }
        isOpen = !isOpen;
    }
}
