package com.gingersoft.gsa.cloud.ui.adapter;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.core.content.ContextCompat;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.common.R;
import com.gingersoft.gsa.cloud.ui.bean.view.CategoryBean;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/11/28
 * Time: 11:45
 * Use:
 */
public class BaseCategoryAdapter extends BaseQuickAdapter<CategoryBean, BaseViewHolder> {

    private int selectedIndex = 0;
    private Drawable selectedBg;
    private Drawable unSelectedBg;

    private int selectColor = -1;
    private int unSelectColor = -1;

    public BaseCategoryAdapter(@Nullable List<CategoryBean> data, Context context) {
        super(R.layout.item_category, data);
        selectedBg = ContextCompat.getDrawable(context, R.drawable.shape_left_radio_shadow);
        unSelectedBg = ContextCompat.getDrawable(context, R.color.trans);
    }

    @Override
    protected void convert(@NotNull BaseViewHolder viewHolder, CategoryBean categoryBean) {
        TextView tvCategoryName = viewHolder.getView(R.id.tv_category_name);
        tvCategoryName.setText(categoryBean.getCategoryName());
        LinearLayout view = viewHolder.getView(R.id.layout_category);
        if (viewHolder.getAdapterPosition() == selectedIndex) {
            if (selectedBg != null) {
                view.setBackground(selectedBg);
            }
            if (selectColor != -1) {
                viewHolder.setTextColor(R.id.tv_category_name, selectColor);
            }
            tvCategoryName.setSelected(true);
        } else {
            tvCategoryName.setSelected(false);
            if (unSelectedBg != null) {
                view.setBackground(unSelectedBg);
            }
            if (unSelectColor != -1) {
                viewHolder.setTextColor(R.id.tv_category_name, unSelectColor);
            }
        }
    }

    public BaseCategoryAdapter setSelectedBg(Drawable selectedBg) {
        this.selectedBg = selectedBg;
        return this;
    }

    public BaseCategoryAdapter setUnSelectedBg(Drawable unSelectedBg) {
        this.unSelectedBg = unSelectedBg;
        return this;
    }

    public BaseCategoryAdapter setSelectColor(int selectColor) {
        this.selectColor = selectColor;
        return this;
    }

    public BaseCategoryAdapter setUnSelectColor(int unSelectColor) {
        this.unSelectColor = unSelectColor;
        return this;
    }

    public void setSelectedIndex(int selectedIndex) {
        this.selectedIndex = selectedIndex;
        notifyDataSetChanged();
    }

    public int getSelectedIndex() {
        return selectedIndex;
    }
}
