package com.gingersoft.gsa.cloud.ui.adapter.multi;

import android.content.Context;
import android.widget.TextView;

import com.chad.library.adapter.base.provider.BaseItemProvider;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.common.R;
import com.gingersoft.gsa.cloud.common.ui.bean.InfoMultiBean;
import com.gingersoft.gsa.cloud.common.utils.other.TextUtil;

import org.jetbrains.annotations.NotNull;

/**
 * @author admin
 */
public class SelectItemProvider<T extends InfoMultiBean> extends BaseItemProvider<T> {
    private Context context;

    public SelectItemProvider(Context context) {
        this.context = context;
    }

    @Override
    public int getItemViewType() {
        return InfoMultiBean.EDIT_FOOD_ITEM_SELECT;
    }

    @Override
    public int getLayoutId() {
        return R.layout.item_multi_select;
    }

    @Override
    public void convert(@NotNull BaseViewHolder baseViewHolder, T infoMultiBean) {
        //是否顯示必選
        baseViewHolder.setGone(R.id.multi_required, !infoMultiBean.isRequired());
        //設置標題
        if (TextUtil.isNotEmptyOrNullOrUndefined(infoMultiBean.getShowTitle())) {
            baseViewHolder.setText(R.id.tv_multi_title, infoMultiBean.getShowTitle());
        } else {
            baseViewHolder.setText(R.id.tv_multi_title, "");
        }
        TextView textView = baseViewHolder.getView(R.id.ed_multi_value);
        if (TextUtil.isNotEmptyOrNullOrUndefined(infoMultiBean.getShowValue())) {
            textView.setText(infoMultiBean.getShowValue());
        } else if (TextUtil.isNotEmptyOrNullOrUndefined(infoMultiBean.getHintText())) {
            textView.setHint(infoMultiBean.getHintText());
        }
    }
}
