package com.gingersoft.coldchain_module.mvp.contract;

import com.gingersoft.coldchain_module.mvp.model.bean.BalanceBean;
import com.gingersoft.coldchain_module.mvp.model.bean.OrderList;
import com.gingersoft.coldchain_module.mvp.model.bean.PickUpBean;
import com.gingersoft.coldchain_module.mvp.model.bean.ShipAnyOrdersNewBean;
import com.gingersoft.coldchain_module.mvp.model.bean.SupplementInfoBean;
import com.gingersoft.coldchain_module.mvp.model.bean.UpdateOrderStatusBean;
import com.gingersoft.coldchain_module.mvp.model.bean.UpdateRestaurantStateBean;
import com.gingersoft.gsa.cloud.common.core.print.bean.OrderDetails;
import com.jess.arms.mvp.IModel;
import com.jess.arms.mvp.IView;

import io.reactivex.Observable;
import okhttp3.RequestBody;


public interface ColdChainMainContract {
    //对于经常使用的关于UI的方法可以定义到IView中,如显示隐藏进度条,和显示文字消息
    interface View extends IView {
        void loadNumber(SupplementInfoBean bean);

        void loadBalance(double price, double bond,boolean isBlink);

        void setRestaurantState(int state);

        void refreshOrderState(long id);
    }

    //Model层定义接口,外部只需关心Model返回的数据,无需关心内部细节,即是否使用缓存getOrderList(@Body RequestBody requestBody);
    interface Model extends IModel {
        Observable<OrderList> getOrderList(RequestBody requestBody);

        Observable<SupplementInfoBean> getNumByOrderType(RequestBody requestBody);

        Observable<PickUpBean> pickUp(RequestBody requestBody);

        Observable<BalanceBean> getBalance(String brandId);

        Observable<UpdateRestaurantStateBean> updateRestOpenStatus(RequestBody requestBody);

        Observable<Object> updateExpandInfo(RequestBody requestBody);

        Observable<OrderDetails> findOrderDetails(RequestBody requestBody);

        Observable<ShipAnyOrdersNewBean> thirdDelivery(RequestBody requestBody);

        Observable<UpdateOrderStatusBean> updateOrderStatus(RequestBody requestBody);

        Observable<String> addPrj(RequestBody requestBody);

    }
}
