package com.joe.print.mvp.print;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import com.gingersoft.gsa.cloud.common.utils.view.QRCodeUtil;
import com.gingersoft.gsa.cloud.database.bean.PrinterDeviceBean;
import com.gingersoft.gsa.cloud.common.core.print.bean.PrintQRCodeContent;
import com.google.zxing.WriterException;
import com.joe.print.R;
import com.joe.print.mvp.model.bean.HtmlLable;
import com.joe.print.mvp.print.common.HtmlContract;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static com.joe.print.mvp.print.common.HtmlContract.LABLE_QRCODE;

/**
 * skyorder qrcode打印
 */
public class PrintQRCode extends PrinterRoot<PrintQRCodeContent> {

    private PrintQRCodeContent mQRCodeBean;

    public PrintQRCode() {
    }

    @Override
    protected void setPrintContent(PrintQRCodeContent printContent) {
        this.mQRCodeBean = printContent;
    }

    @Override
    public Map<String, List<Bitmap>> getPrintBitmap(Context mContext, PrinterDeviceBean printerDeviceBean) {
        Map<String, List<Bitmap>> bitmapMaps = new HashMap<>();
        List<Bitmap> bitmaps = new ArrayList<>();
        bitmaps.add(getBitmap(mContext, printerDeviceBean));
        bitmapMaps.put("", bitmaps);
        return bitmapMaps;
    }

    @Override
    public String[] getPrintDatas(Context mContext, PrinterDeviceBean deviceBean) {
        if (mQRCodeBean == null) {
            return new String[]{"<html><body></body></html>"};
        }
        String stringBuilder = "<html><body>" +
                getHtmlContent() +
                "</body></html>";
        int printCount = getPrintCount(mContext);
        String[] pritContent = new String[printCount];
        for (int i = 0; i < printCount; i++) {
            pritContent[i] = stringBuilder;
        }
        return pritContent;
    }

    private String getHtmlContent() {
        List<HtmlLable> htmlLables = new ArrayList<>();

        //頭部
        htmlLables.add(new HtmlLable(HtmlContract.LABLE_H3,mQRCodeBean.getPrintTableName(), new HtmlLable.Attributes(HtmlContract.ATTRIBUTES_ALIGN, HtmlContract.value_align_center,HtmlContract.value_type_string)));
        htmlLables.add(new HtmlLable(HtmlContract.LABLE_P,mQRCodeBean.getPrintTopInfo(),
                new HtmlLable.Attributes(HtmlContract.ATTRIBUTES_ALIGN, HtmlContract.value_align_center,HtmlContract.value_type_string),
                new HtmlLable.Attributes(HtmlContract.ATTRIBUTES_FONT_SIZE,"25")));

        //qrcode
        htmlLables.add(new HtmlLable(LABLE_QRCODE, mQRCodeBean.getPrintQrcode(), new HtmlLable.Attributes(HtmlContract.ATTRIBUTES_SCALE, HtmlContract.value_scale_1, HtmlContract.value_type_string)));

        //底部
        htmlLables.add(new HtmlLable(HtmlContract.LABLE_P,mQRCodeBean.getPrintTime(),new HtmlLable.Attributes(HtmlContract.ATTRIBUTES_FONT_SIZE,"25")));
        htmlLables.add(new HtmlLable(HtmlContract.LABLE_P,mQRCodeBean.getPrintPeopleNum(),new HtmlLable.Attributes(HtmlContract.ATTRIBUTES_FONT_SIZE,"25")));
        htmlLables.add(new HtmlLable(HtmlContract.LABLE_P,mQRCodeBean.getPrintMealEndTime(),new HtmlLable.Attributes(HtmlContract.ATTRIBUTES_FONT_SIZE,"25")));
        htmlLables.add(new HtmlLable(HtmlContract.LABLE_P,mQRCodeBean.getPrintBottonInfo(),new HtmlLable.Attributes(HtmlContract.ATTRIBUTES_FONT_SIZE,"25")));

        return getHtmlLables(htmlLables.toArray(new HtmlLable[htmlLables.size()]));
    }

    @Override
    public int getPrintCount(Context context) {
        return 1;
    }


    private Bitmap getBitmap(Context mContext, PrinterDeviceBean printerDeviceBean) {
        return viewToZoomBitmap(mContext, getPrintView(mContext), printerDeviceBean);
    }

    public View getPrintView(Context context) {
        View view = View.inflate(context, R.layout.print_skyorder_qrcode, null);
        TextView printTableName = view.findViewById(R.id.print_table_name);
        TextView printTopInfo = view.findViewById(R.id.print_top_info);
        ImageView printQrcode = view.findViewById(R.id.print_qrcode);
        TextView printTime = view.findViewById(R.id.print_time);
        TextView printPeopleNum = view.findViewById(R.id.print_people_num);
        TextView printMealEndTime = view.findViewById(R.id.print_meal_end_time);
        TextView printBottonInfo = view.findViewById(R.id.print_botton_info);

        printTableName.setText(mQRCodeBean.getPrintTableName());
        printTopInfo.setText(mQRCodeBean.getPrintTopInfo());
        printTime.setText(mQRCodeBean.getPrintTime());
        printPeopleNum.setText(mQRCodeBean.getPrintPeopleNum());
        printMealEndTime.setText(mQRCodeBean.getPrintMealEndTime());
        printBottonInfo.setText(mQRCodeBean.getPrintBottonInfo());

        Bitmap QRImage = null;
        try {
            QRImage = QRCodeUtil.makeQRImage(mQRCodeBean.getPrintQrcode(), 250, 250);
        } catch (WriterException e) {
            e.printStackTrace();
        }
        if (QRImage != null) {
            printQrcode.setImageBitmap(QRImage);
        }
        return view;
    }
}
