package com.gingersoft.supply_chain.mvp.bean;

import java.io.Serializable;
import java.util.List;

import lombok.Data;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/11/19
 * Time: 18:01
 * Use: 供應商信息
 */
@Data
public class SupplierInfoBean implements Serializable {
    private static final long serialVersionUID = 9167054021101810555L;

    private int id;
    private String supplierNo;
    private String contactInformation;
    private String supplierName;
    private String address;
    private String remarks;
    private String contacts;
    private String createDate;
    private int restaurantId;
    private int brandId;
    private int uid;
    private int countryId;
    private long createTime;
    private long updateTime;
    private int deletes;

    public static final int DELETE = 1;
    public static final int NORMAL = 0;

    private List<SupplierContacts> supplierContacts;

    public SupplierInfoBean(String supplierName, String address, String contactInformation, String contacts, String createDate) {
        this.contactInformation = contactInformation;
        this.supplierName = supplierName;
        this.address = address;
        this.contacts = contacts;
        this.createDate = createDate;
    }

    public SupplierInfoBean() {
    }

    @Data
    public static class SupplierContacts implements Serializable {
        private static final long serialVersionUID = -4586838211196656718L;
        private int id;
        private int supplierId;
        private String configText;
        private long createTime;
        private long updateTime;
        /**
         * 聯繫方式
         * 1、郵箱
         * 2、Whatsapp
         * 3、ehat
         * 4、line
         * 5、Kakao
         * 6、Talk
         * 7、SMS
         * 8、efax
         */
        private int type;
        public final static int Email = 1;
        public final static int SMS = 6;
        public final static int Efax = 7;
        //接收軟件
        public final static int Whatsapp = 2;
        public final static int WeChat = 3;
        public final static int Line = 4;
        public final static int Kakao_Talk= 5;

        public SupplierContacts() {
        }

        public SupplierContacts(String configText, int type) {
            this.configText = configText;
            this.type = type;
        }
    }
}
