package com.gingersoft.supply_chain.mvp.content;

import com.gingersoft.supply_chain.mvp.bean.PurchaseFoodListVosBean;

import java.util.ArrayList;
import java.util.List;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/12/4
 * Time: 11:21
 * Use: 供應鏈購物車,需要緩存用戶選中的食品
 */
public class SupplyShoppingCart {
    /**
     * key為食品id
     * value為食品信息
     */
    private static List<PurchaseFoodListVosBean> cartFoods;

    private static SupplyShoppingCart shoppingCart;

    public static SupplyShoppingCart getInstance() {
        if (shoppingCart == null) {
            shoppingCart = new SupplyShoppingCart();
        }
        return shoppingCart;
    }

    public List<PurchaseFoodListVosBean> getCartFoods() {
        if (cartFoods == null) {
            cartFoods = new ArrayList<>();
        }
        return cartFoods;
    }

    public void setCartFoods(List<PurchaseFoodListVosBean> cartFoods) {
        SupplyShoppingCart.cartFoods = cartFoods;
    }
}
