package com.gingersoft.supply_chain.mvp.ui.adapter;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.common.utils.time.TimeUtils;
import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.mvp.bean.OrderBean;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/12/2
 * Time: 17:36
 * Use: 採購訂單列表
 */
public class PurchaseOrderAdapter extends BaseQuickAdapter<OrderBean, BaseViewHolder> {

    public PurchaseOrderAdapter(@Nullable List<OrderBean> data) {
        super(R.layout.item_purchase_order, data);
        addChildClickViewIds(R.id.btn_purchase_send, R.id.btn_purchase_buy_again, R.id.btn_receiver_goods);
    }

    @Override
    protected void convert(@NotNull BaseViewHolder viewHolder, OrderBean purchaseOrderBean) {
        viewHolder.setText(R.id.tv_purchase_order_no, "" + purchaseOrderBean.getOrderNo());
        viewHolder.setText(R.id.tv_purchase_order_create_time, TimeUtils.getTime(purchaseOrderBean.getCreateTime(), TimeUtils.DEFAULT_DATE_FORMAT_YMDHM));
        viewHolder.setText(R.id.tv_purchase_order_goods_num, purchaseOrderBean.getFoodCount() + "");
//        viewHolder.setText(R.id.tv_purchase_order_goods, purchaseOrderBean.getFoods());
        viewHolder.setText(R.id.tv_purchase_order_total_price, purchaseOrderBean.getTotalAmount() + "");
//        viewHolder.setText(R.id.tv_purchase_order_time_out, purchaseOrderBean.getTotal() + "");
    }
}
