package com.gingersoft.supply_chain.mvp.ui.adapter;

import android.graphics.drawable.Drawable;
import android.widget.TextView;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.common.utils.other.TextUtil;
import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.mvp.bean.FoodCategoryResultBean;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/11/28
 * Time: 15:41
 * Use:
 */
public class SecondCategoryAdapter extends BaseQuickAdapter<FoodCategoryResultBean.DataBean.FoodCategoryBean, BaseViewHolder> {

    private int selectIndex = 0;
    private Drawable checkedBg;
    private Drawable unCheckedBg;

    private int checkedTextColor;
    private int unCheckedTextColor;

    public SecondCategoryAdapter(@Nullable List<FoodCategoryResultBean.DataBean.FoodCategoryBean> data) {
        super(R.layout.item_second_category, data);
    }

    @Override
    protected void convert(@NotNull BaseViewHolder viewHolder, FoodCategoryResultBean.DataBean.FoodCategoryBean categoryBean) {
        viewHolder.setText(R.id.tv_second_category_title, categoryBean.getName());
        TextView tvName = viewHolder.getView(R.id.tv_second_category_title);
        viewHolder.setVisible(R.id.tv_second_category_title, TextUtil.isNotEmptyOrNullOrUndefined(categoryBean.getName()));
        if (viewHolder.getAdapterPosition() == selectIndex) {
            if (checkedBg != null) {
                tvName.setBackground(checkedBg);
            }
            if (checkedTextColor != 0) {
                tvName.setTextColor(checkedTextColor);
            }
        } else {
            if (unCheckedBg != null) {
                tvName.setBackground(unCheckedBg);
            }
            if (unCheckedTextColor != 0) {
                tvName.setTextColor(unCheckedTextColor);
            }
        }
    }

    public SecondCategoryAdapter setCheckedBg(Drawable checkedBg) {
        this.checkedBg = checkedBg;
        return this;
    }

    public SecondCategoryAdapter setUnCheckedBg(Drawable unCheckedBg) {
        this.unCheckedBg = unCheckedBg;
        return this;
    }

    public SecondCategoryAdapter setSelectIndex(int selectIndex) {
        this.selectIndex = selectIndex;
        notifyDataSetChanged();
        return this;
    }

    public SecondCategoryAdapter setCheckedTextColor(int checkedTextColor) {
        this.checkedTextColor = checkedTextColor;
        return this;
    }

    public SecondCategoryAdapter setUnCheckedTextColor(int unCheckedTextColor) {
        this.unCheckedTextColor = unCheckedTextColor;
        return this;
    }

    public int getSelectIndex() {
        return selectIndex;
    }

    public FoodCategoryResultBean.DataBean.FoodCategoryBean getSelectData(){
        return getData().get(selectIndex);
    }
}
