package com.gingersoft.gsa.cloud.table.mvp.ui.adapter;

import android.widget.TextView;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.table.R;
import com.gingersoft.gsa.cloud.common.ui.bean.view.SectionTextItem3;

import java.util.List;

import androidx.annotation.Nullable;

public class OrderCenterMoneyAdapter extends BaseQuickAdapter<SectionTextItem3, BaseViewHolder> {

    public OrderCenterMoneyAdapter(@Nullable List<SectionTextItem3> data) {
        super(R.layout.item_order_detail_pay_method, data);
    }

    @Override
    protected void convert(BaseViewHolder helper, SectionTextItem3 item) {
        if (Double.parseDouble(item.getRightText()) < 0) {
            //折扣
            helper.setText(R.id.tv_money, "-$" + Math.abs(Double.parseDouble(item.getRightText())));
        } else {
            helper.setText(R.id.tv_money, "$" + item.getRightText());
        }
        helper.setText(R.id.tv_name, String.valueOf(item.getLeftText()));

        TextView tv_name = helper.getView(R.id.tv_name);
        TextView tv_money = helper.getView(R.id.tv_money);
        tv_name.setTextAppearance(getContext(), item.getLeftTextStyle());
        tv_money.setTextAppearance(getContext(), item.getRightTextStyle());
    }

}
